%def_enable snapshot
%define ver_major 3.32
%define api_ver 1.0
%define xdg_name org.gnome.gitg

%def_enable python
%def_enable glade
%def_enable docs
%def_disable check

Name: gitg
Version: %ver_major.1
Release: alt2

Summary: git repository viewer targeting gtk+/GNOME
Group: Development/Other
License: GPL-2.0
Url: https://wiki.gnome.org/Apps/Gitg

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %version-%release
# gitg/gitg-plugins-engine.vala: repo.require("PeasGtk", "1.0", 0);
Requires: typelib(PeasGtk)

%define gitg_pluginsdir %_libdir/%name/plugins

%define glib_ver 2.38
%define gtk_ver 3.20
%define gtksourceview_ver 3.10
%define git2_ver 0.27.7
%define webkit_ver 2.6.0
%define gtkspell_ver 3.0.3
%define peas_ver 1.5.0

BuildRequires(pre): meson rpm-build-gir rpm-build-python3 rpm-build-vala
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libdazzle-devel
BuildRequires: libgit2-glib-devel >= %git2_ver
BuildRequires: libgtksourceview3-devel >= %gtksourceview_ver
BuildRequires: libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libgtkspell3-devel >= %gtkspell_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: gnome-common intltool desktop-file-utils
BuildRequires: libgee0.8-devel libjson-glib-devel libsecret-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxml2-devel
BuildRequires: libgit2-glib-gir-devel libwebkit2gtk-gir-devel libgee0.8-gir-devel
BuildRequires: libgtkspell3-gir-devel
BuildRequires: vala-tools
BuildRequires: gsettings-desktop-schemas-devel
%{?_enable_docs:BuildRequires: valadoc}
%{?_enable_python:BuildRequires(pre): rpm-build-python3}
%{?_enable_python:BuildRequires: python3-devel python3-module-pygobject3-devel}

%description
Gitg is a graphical user interface for git. It aims at being a small,
fast and convenient tool to visualize the history of git repositories.
Besides visualization, gitg also provides several utilities to manage your
repository and commit your work.

%package -n lib%name
Summary: lib%name library
Group: System/Libraries

%description -n lib%name
Gitg is a graphical user interface for git. It aims at being a small,
fast and convenient tool to visualize the history of git repositories.
Besides visualization, gitg also provides several utilities to manage your
repository and commit your work.

This package provides shared Gitg library.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Gitg is a graphical user interface for git. It aims at being a small,
fast and convenient tool to visualize the history of git repositories.
Besides visualization, gitg also provides several utilities to manage your
repository and commit your work.

This package provides headers and libraries to develop plugins for Gitg
or other applications

%package -n lib%name-gir
Summary: GObject introspection data for the Gitg library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
This package provides GObject introspection data for the Gitg
library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Gitg library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
This package provides GObject introspection devel data for the Gitg
library.

%prep
%setup
# fix python install path
subst "s/purelib/platlib/" libgitg-ext/meson.build
# remove useless rpath
subst "/install_rpath/d" %name/meson.build

%build
%meson %{?_disable_python:-Dpython=false} \
	%{?_disable_glade:-Dglade_catalog=false} \
	%{?_enable_docs:-Ddocs=true}
%meson_build

%install
%meson_install
%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RevisionControl \
	%buildroot%_desktopdir/%xdg_name.desktop

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_bindir/%name
%gitg_pluginsdir/
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_man1dir/%{name}*
%_iconsdir/hicolor/*x*/apps/*
%_iconsdir/hicolor/scalable/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%{?_enable_python:%python3_sitelibdir/gi/overrides/*}
%doc AUTHORS NEWS README*

%files -n lib%name
%_libdir/lib%name-%api_ver.so.*
%_libdir/lib%name-ext-%api_ver.so.*

%files -n lib%name-devel
%_includedir/lib%name-%api_ver/
%_includedir/lib%name-ext-%api_ver/
%_libdir/lib%name-%api_ver.so
%_libdir/lib%name-ext-%api_ver.so
%_pkgconfigdir/lib%name-%api_ver.pc
%_pkgconfigdir/lib%name-ext-%api_ver.pc
%{?_enable_glade:%_datadir/glade/catalogs/gitg-glade.xml}
%_vapidir/lib%name-%api_ver.vapi
%_vapidir/lib%name-ext-1.0.vapi

%files -n lib%name-gir
%_typelibdir/Gitg-%api_ver.typelib
%_typelibdir/GitgExt-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Gitg-%api_ver.gir
%_girdir/GitgExt-%api_ver.gir

%changelog
