%define glibc_sourcedir /usr/src/glibc-source

Name: glibc
Version: 2.32
Release: alt5.p10.5
Epoch: 6

Summary: The GNU libc libraries
# GPLv2+ is used in a bunch of programs, LGPLv2+ is used for libraries.
# Things that are linked directly into dynamically linked programs
# and shared libraries (e.g. crt files, lib*_nonshared.a) have an additional
# exception which allows linking it into any kind of programs or shared
# libraries without restrictions.
License: LGPL-2.1+ and ISC and BSD-3-Clause and GPL-2.0-or-later
Group: System/Base
Url: http://www.gnu.org/software/glibc/

# Remove -s to get verbose output.
%define PARALLELMFLAGS PARALLELMFLAGS='-j%__nprocs'

%def_with optimization
%def_enable langify
%def_with locales
%def_enable memusagestat

%ifarch x86_64
%def_enable multiarch
%else
%def_disable multiarch
%endif

%ifarch aarch64 i586 x86_64
%def_enable static_pie
%else
%def_disable static_pie
%endif

%define basever 2.32

%define enablekernel 3.2

%ifarch aarch64
%define enablekernel 3.7.0
%endif

%ifarch x32
%define enablekernel 3.4.0
%endif

%ifarch ppc64le
%define enablekernel 3.10.0
%endif

# http://git.altlinux.org/gears/g/glibc.git
Source: glibc-%version-%release.tar

Obsoletes: libc-static, libc-devel, libc-profile, libc-headers,
Obsoletes: linuxthreads, gencat, ldconfig

%define libc_locales_list aa af am an ar as ast ayc az be bem ber bg bho bn bo br brx bs byn ca crh cs csb cv cy da de doi dv dz el en es et eu fa ff fi fil fo fr fur fy ga gd gez gl gu gv ha he hi hne hr hsb ht hu hy ia id ig ik is it iu iw ja ka kk kl km kn ko kok ks ku kw ky lb lg li lij lo lt lv mag mai mg mhr mi mk ml mn mni mr ms mt my nan nb nds ne nhn niu nl nn nr nso oc om or os pa pap pl ps pt ro ru rw sa sat sc sd se shs si sid sk sl so sq sr ss st sv sw szl ta te tg th ti tig tk tl tn tr ts tt ug uk unm ur uz ve vi wa wae wal wo xh yi yo yue zh zu
%define libc_locales %(for i in %libc_locales_list;do echo -n "locale-$i locales-$i ";done)
%define renamed_locales ru_RU.iso88595 ru_UA.koi8u uk_UA.koi8u

PreReq: %name-core = %EVR
PreReq: %name-pthread = %EVR
PreReq: %name-nss = %EVR
PreReq: %name-locales = %EVR
PreReq: %name-gconv-modules = %EVR
PreReq: iconv = %EVR
PreReq: %name-timezones = %EVR
PreReq: %name-utils = %EVR

# Required to hardlink identical locale files.
BuildPreReq: hardlink

# Due to STB_GNU_UNIQUE
BuildPreReq: binutils >= 1:2.20

# Due to enablekernel.
BuildPreReq: glibc-kernheaders >= %enablekernel

BuildPreReq: rpm-build >= 4.0.4-alt112

# This is required for building auxiliary programs.
%{?!_disable_memusagestat:BuildPreReq: libgd2-devel}

BuildPreReq: makeinfo python3

# g++ and /proc are required for test suite.
%{?!_without_check:%{?!_disable_check:BuildPreReq: gcc-c++ libstdc++-devel-static /proc /dev/pts}}

%define _localstatedir /var
%define _gconvdir %_libdir/gconv
%filter_from_provides /GLIBC_PRIVATE/d
%filter_from_requires /GLIBC_PRIVATE/d

%ifarch aarch64
%filter_from_provides s@^ld-linux-aarch64\.so\.1.*@&\n/lib/&@
%endif

%package preinstall
Summary: The GNU libc preinstall utilities
Group: System/Base
AutoReq: no
PreReq: filesystem

%package core
Summary: The GNU libc core libraries and utilities
Group: System/Libraries
AutoReq: no
PreReq: setup
PreReq: %name-preinstall >= %EVR
Conflicts: %name < %EVR
Conflicts: glibc-core-archopt
Conflicts: openssh-server < 7.9p1-alt2
Conflicts: openssh-server-gostcrypto < 7.9p1-alt4.gost
Provides: linuxthreads, ldconfig
Obsoletes: linuxthreads, ldconfig
# The dynamic linker supports DT_GNU_HASH
Provides: rtld(GNU_HASH)
# The dynamic linker supports STB_GNU_UNIQUE
Provides: rtld(GNU_UNIQUE)
# The dynamic linker supports STT_GNU_IFUNC
Provides: rtld(GNU_IFUNC)

%package pthread
Summary: The GNU libc pthread libraries
Group: System/Libraries
PreReq: %name-core = %EVR
%define lib_suffix %{?_is_libsuff:()(%{_libsuff}bit)}
# due to pthread_cancel_init() which calls __libc_dlopen ("libgcc_s.so.1")
Requires: libgcc_s.so.1%lib_suffix

%package nss
Summary: The GNU libc Name Service Switch subsystem
Group: System/Libraries
PreReq: %name-pthread = %EVR

%package -n libnsl1
Summary: Legacy NIS support library
Group: System/Legacy libraries
PreReq: %name-core = %EVR

%package locales
Summary: The GNU libc locales
Group: System/Internationalization
PreReq: %name-pthread = %EVR
Provides: %name-locales-virtual = %EVR
Provides: locale locales %libc_locales
Obsoletes: locale locales %libc_locales
Obsoletes: %name-locales-junior
Obsoletes: i586-glibc-locales

%package i18ndata
Summary: Files for building customized GNU libc locales
Group: System/Base
BuildArch: noarch
PreReq: %name-core = %EVR
Obsoletes: %name-localedata
Provides: %name-localedata
Conflicts: mutt < 1.3.22.1i

%package gconv-modules
Summary: The GNU libc charset conversion modules
Group: System/Base
PreReq: %name-pthread = %EVR
# hack
Provides: %(test %_lib = lib64 && s='()(64bit)' || s=; for n in CNS GB ISOIR165 JIS JISX0213 KSC; do echo -n "lib$n.so$s %_libdir/gconv/lib$n.so$s "; done)

%package -n iconv
Summary: The GNU libc charset conversion modules
Group: System/Base
PreReq: %name-gconv-modules = %EVR

%package timezones
Summary: The GNU libc timezones data
Group: System/Base
PreReq: %name-pthread = %EVR
Requires: tzdata

%package utils
Summary: The GNU libc misc utilities
Group: System/Base
PreReq: %name-pthread = %EVR
Requires: mktemp >= 1:1.3.1
Provides: gencat
Obsoletes: gencat
# due to rpcinfo
Conflicts: rpcbind < 0.2.1-alt0.4

%package devel
Summary: Include and object files required for C development
Group: Development/C
Requires: %name = %EVR
Requires: glibc-kernheaders >= %enablekernel
Requires: kernel-headers-common >= 1.1.4-alt1
Requires: libcrypt-devel
#Requires: %name-doc = %EVR
%ifarch %ix86 x86_64 %arm
Provides: %_includedir/gnu/stubs-32.h
%endif
%ifarch %ix86
# Earlier gcc's had atexit reference in crtendS.o, which does not
# work with this glibc where atexit is in libc_nonshared.a
Conflicts: gcc < 0:2.96-ipl9mdk
%endif
Obsoletes: libc-headers, libc-devel, linuxthreads-devel

%package devel-static
Summary: Static libraries for C development
Group: Development/C
Requires: %name-devel = %EVR
Obsoletes: libc-static

%package doc
Summary: Documentation for C development
Group: Development/Other
BuildArch: noarch
PreReq: %name-pthread = %EVR
Conflicts: texinfo < 3.11

%package debug
Summary: The GNU libc utilities for software debugging
Group: Development/C
Requires: %name-devel = %EVR
Obsoletes: libc-debug

%package -n nscd
Summary: A Name Service Caching Daemon (nscd)
Group: System/Servers
Conflicts: kernel < 2.2.0
PreReq: shadow-utils
PreReq: %name-pthread = %EVR

%package source
Summary: GNU libc sources
Group: Development/Other
BuildArch: noarch

%description
The GNU C library defines all of the library functions that are specified
by the ISO C standard, as well as additional features specific to POSIX
and other derivatives of the Unix operating system, and extensions
specific to the GNU system.

The GNU libc is a set of standard libraries which are used by multiple
programs on the system.  In order to save disk space and memory, as well
as to make upgrading easier, common system code is kept in one place
and shared between programs.

%description preinstall
This package contains glibc preinstall utility.

%description core
This package contains most essential GNU libc libraries and files,
including dynamic linker and its configurator, standard C library and
the standard math library.  Without these files a GNU/Linux system will
not function.

%description pthread
This package contains glibc libpthread and related shared libraries.

%description locales
This package contains GNU libc locales, files that tell your system
about your language, names of days and months, charset, and other
language/territory/charset specific things.

%description i18ndata
This package contains source files required for building locales.  Locales
are files, that tell your system about your language, names of days and
months, alphabet and other language/territory/charset specific things.

%description gconv-modules
This package contains helper modules necessary to convert data between
various charsets.

%description -n iconv
This package contains program that can convert text files between
various charsets.

%description timezones
This package contains files, utilities and databases for operating
timezones data in the system.

%description utils
This package contains miscellaneous non-essential %name utilities that
didn't fit in specific packages.

%description nss
NSS is a Name Service Switch subsystem.  The basic idea is to put the
implementation of the different services offered to access the databases
in separate modules.

%description -n libnsl1
This package provides the legacy version of libnsl library, for
accessing NIS services.

This library is provided for backwards compatibility only;
applications should use libnsl2 instead to gain IPv6 support.

%description devel
This package contains the header and object files necessary for developing
programs which use the standard C libraries (which are used by nearly all
programs).  If you are developing programs which will use the standard
C libraries, your system needs to have these standard header and object
files available in order to create the executables.

%description devel-static
This package contains the GNU libc static libraries necessary for
developing statically linked programs which use the standard C libraries.

%description doc
This package contains documentation distributed with GNU libc.

%description debug
This package contains utilities for software debugging,
including:
+ memusage
+ memusagestat
+ pcprofiledump
+ xtrace

%description -n nscd
The nscd daemon caches name service lookups and can improve
performance with LDAP, and may help with DNS as well.

%description source
This package contains source code of GNU libc.

%prep
%setup -n %name-%version-%release

find -type f -name configure -print0 |
	xargs -r0 touch --

################################################################################
%build
%define buildtarget build-%_target

%if_without optimization
%define _optlevel %nil
%define optflags_optimization -O%_optlevel %optflags_debug
%else #with optimization

%endif #without optimization

%define _configure_script ../configure

# workaround
unset LD_PRELOAD LD_ASSUME_KERNEL ||:

export CC=%__cc CXX=%__cxx \
	ac_cv_lib_audit_audit_log_avc=no \
	ac_cv_path_BASH_SHELL=/bin/sh \
	ac_cv_path_KSH=/bin/sh \
	#

rm -rf %buildtarget
mkdir %buildtarget
pushd %buildtarget

%configure \
	--disable-crypt \
	--disable-profile \
	--enable-bind-now \
	%{?_enable_multiarch:--enable-multi-arch} \
	--enable-obsolete-rpc \
	--enable-kernel=%enablekernel \
	--enable-tunables \
	--enable-stack-protector=strong \
	%{?_enable_static_pie:--enable-static-pie} \
	#

make %PARALLELMFLAGS

popd #%buildtarget

make -C alt CC=%__cc objdir=../%buildtarget

################################################################################
%install
%makeinstall_std %PARALLELMFLAGS -C %buildtarget

pushd %buildroot%_libdir
%__cc -r -nostdlib -o libpthread.o -Wl,--whole-archive ./libpthread.a
rm libpthread.a
ar rcs libpthread.a libpthread.o
rm libpthread.o
popd

mkdir -p %buildroot%_cachedir/ldconfig
> %buildroot%_cachedir/ldconfig/aux-cache

# Relocate shared libraries used by catchsegv, memusage and xtrace.
mv %buildroot/%_lib/lib{memusage,pcprofile,SegFault}.so \
	%buildroot%_libdir/ ||:

# Relocate libnsl.
mv %buildroot/%_lib/libnsl{-*.so,.so.1} %buildroot%_libdir/

# Install upgrade programs.
make -C alt install

%if_with locales
make -r %PARALLELMFLAGS -j%__nprocs install-locales -C localedata \
	DESTDIR=%buildroot objdir=$PWD/%buildtarget

# Hardlink identical locale files together.
hardlink -vc %buildroot%_prefix/lib/locale

# Convert these locale directories into symlinks.
for n in %renamed_locales; do
	t=%buildroot%_prefix/lib/locale/"${n%%.*}"
	rm -rf "$t"
	ln -s "$n" "$t"
done
%endif #with locales

mkdir -p %buildroot{%_initdir,%_unitdir,/etc/sysconfig,/lib/tmpfiles.d}
install -pm644 alt/nsswitch.conf %buildroot/etc/
install -pm644 nscd/nscd.conf %buildroot/etc/
install -pm755 alt/nscd.init %buildroot%_initdir/nscd
install -pm644 alt/nscd.{service,socket} %buildroot%_unitdir/
install -pm644 alt/nscd.conf %buildroot/lib/tmpfiles.d/
touch %buildroot/etc/sysconfig/nscd
mkdir -pm711 %buildroot/var/{lib,run}/nscd
mksock %buildroot/var/run/nscd/socket
touch %buildroot/var/run/nscd/nscd.pid
touch %buildroot/var/{lib,run}/nscd/{passwd,group,hosts,services}

%ifarch x86_64
install -pm644 alt/stubs-32.h %buildroot%_includedir/gnu/
%endif
%ifarch %ix86
cmp alt/stubs-32.h %buildroot%_includedir/gnu/stubs-32.h || {
	echo 'Bundled stubs-32.h is out of date'
	exit 1
}
%endif

# Install nss.conf
install -pm644 nis/nss %buildroot%_sysconfdir/nss.conf

# Install gai.conf
install -pm644 posix/gai.conf %buildroot%_sysconfdir/

# Install bindresvport.blacklist
install -pm644 alt/bindresvport.blacklist %buildroot%_sysconfdir/

# Include ld.so.conf and ld.so.conf.d
mkdir -p %buildroot%_sysconfdir/ld.so.conf.d
echo 'include /etc/ld.so.conf.d/*.conf' >%buildroot%_sysconfdir/ld.so.conf

# Include %%ghost ld.so.cache
install -pD -m644 /dev/null %buildroot%_sysconfdir/ld.so.cache

# Include gconv-modules.cache
install -pD -m644 /dev/null %buildroot%_gconvdir/gconv-modules.cache

# Create /etc/localtime
touch %buildroot%_sysconfdir/localtime

# zoneinfo now lives in tzdata package.
rm -rf %buildroot%_datadir/zoneinfo

# Remove unpackaged files
rm %buildroot{%_infodir/dir,%_datadir/locale/locale.alias}

# The last bit: more documentation.
%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
cp -pL LICENSES README* alt/README* NEWS \
	%buildroot%docdir/
find %buildroot%docdir/ -type f -size +8k -print0 |
	xargs -r0 xz -9

>devel.files
>devel-static.files
for f in `ls %buildroot%_libdir/lib*.a |
	  grep -v '_p.a$' |
	  sed -e "s|%buildroot||g"`; do
	if [ -e "%buildroot${f%%.a}.so" ] || [ -e "%buildroot${f%%-%basever.a}.so" ]; then
		echo "$f" >>devel-static.files
	else
		echo "$f" >>devel.files
	fi
done

%find_lang libc

%if_with locales
%if_enabled langify
(
	cd %buildroot%_prefix/lib/locale
	for f in *; do
		n=${f%%%%@*}
		n=${n%%%%.*}
		n=${n%%%%_*}
		echo "%%lang($n) %%attr(-,root,root) %_prefix/lib/locale/$f"
	done
) >>libc.lang
%endif #enabled langify

echo '%%dir %_datadir/locale' >>libc.lang
for lang in $((cat alt/locales-add && cd %buildroot%_prefix/lib/locale && ls |sed 's/[.@].*//') |sort -u); do
	for n in $lang ${lang%%%%_*}; do
		mkdir -p "%buildroot%_datadir/locale/$n"/LC_{MESSAGES,TIME}
		echo "%%lang($n) %%dir %_datadir/locale/$n"
		echo "%%lang($n) %%dir %_datadir/locale/$n/LC_MESSAGES"
		echo "%%lang($n) %%dir %_datadir/locale/$n/LC_TIME"
	done
done |sort -u >>libc.lang
%endif #with locales

mkdir -p %buildroot%glibc_sourcedir
cp %SOURCE0 %buildroot%glibc_sourcedir/

%ifarch aarch64
ln -s /lib64/ld-linux-aarch64.so.1 %buildroot/lib/
%endif
%ifarch riscv64
ln -s /lib64/ld-linux-riscv64-lp64d.so.1 %buildroot/lib/
%endif

%brp_strip_debug */%_lib/ld-*.so* */%_lib/libpthread-*.so

# due to libpthread.
%set_verify_elf_method unresolved=relaxed

################################################################################
%check
cat /proc/self/maps >/dev/null
export TIMEOUTFACTOR=10

cat > %buildtarget/xfail.mk <<@@@
export test-xfail-XPG4/unistd.h/linknamespace = yes
export test-xfail-tst-resolv-search=yes
export test-xfail-tst-default-attr=yes
%ifarch x86_64
export test-xfail-test-ildouble=yes
%endif
%ifarch %ix86
export test-xfail-test-double-finite=yes
export test-xfail-test-double=yes
export test-xfail-test-float-finite-y0=yes
export test-xfail-test-float-y0=yes
export test-xfail-test-float32-finite-y0=yes
export test-xfail-test-float32-y0=yes
export test-xfail-test-float64x-clog10=yes
export test-xfail-test-float64x-finite-clog10=yes
export test-xfail-test-float64x-finite-lgamma=yes
export test-xfail-test-float64x-lgamma=yes
export test-xfail-test-idouble=yes
export test-xfail-test-ifloat-y0=yes
export test-xfail-test-ifloat32-y0=yes
export test-xfail-test-ifloat64x-clog10=yes
export test-xfail-test-ifloat64x-lgamma=yes
export test-xfail-test-ildouble-acosh=yes
export test-xfail-test-ildouble-clog10=yes
export test-xfail-test-ildouble-lgamma=yes
export test-xfail-test-ildouble=yes
export test-xfail-test-ldouble-clog10=yes
export test-xfail-test-ldouble-finite-clog10=yes
export test-xfail-test-ldouble-finite-lgamma=yes
export test-xfail-test-ldouble-finite=yes
export test-xfail-test-ldouble-lgamma=yes
export test-xfail-test-ldouble=yes
export test-xfail-tst-malloc-usable-tunables=yes
%endif
%ifarch aarch64
export test-xfail-test-errno-linux=yes
export test-xfail-tst-mlock2=yes
export test-xfail-tst-pkey=yes
export test-xfail-tst-clock2=yes
export test-xfail-tst-rwlock9=yes
export test-xfail-tst-rwlock18=yes
%endif
%ifarch ppc64le
export test-xfail-tst-pkey=yes
%endif

include Makefile
@@@

ulimit -u $(ulimit -Hu)
make %PARALLELMFLAGS -C %buildtarget -f xfail.mk -k check fast-check=yes LDFLAGS=-Wl,--no-as-needed || {
  rc=$?
  grep '^FAIL:' %buildtarget/tests.sum | cut -d" " -f2- |
    xargs -i tail -v -n 100 %buildtarget/{}.test-result %buildtarget/{}.out ||:
# architectures we care for enough to fail here
%ifarch %ix86 x86_64 aarch64 ppc64le
  exit $rc
%endif
}
cat %buildtarget/tests.sum

%pre core -p /sbin/glibc_preinstall
%post core -p /sbin/glibc_post_upgrade

%post -n iconv
%_sbindir/iconvconfig

%pre locales
for n in %renamed_locales; do
	f="%_prefix/lib/locale/${n%%.*}"
	if [ -d "$f" -a ! -L "$f" ]; then
		rm -rf "$f"
		touch "$f.RPMLOCK"
	fi
done
%if "%_libdir" != "%_prefix/lib"
if [ -L %_prefix/lib/locale ]; then
	rm -f %_prefix/lib/locale
fi
%endif

%post locales
for n in %renamed_locales; do
	d="%_prefix/lib/locale/$n"
	f="%_prefix/lib/locale/${n%%.*}"
	if [ -f "$f.RPMLOCK" -a -d "$f" -a ! -d "$d.RPMSAVE" ]; then
		mv "$d" "$d.RPMSAVE"
		rm -f "$f.RPMLOCK"
	fi
done

%triggerpostun locales -- %name-locales, %name < 6:2.2.4-alt3
for n in %renamed_locales; do
	d="%_prefix/lib/locale/$n"
	if [ -d "$d.RPMSAVE" -a ! -d "$d" ]; then
		mv "$d.RPMSAVE" "$d"
	fi
done

%pre devel
# This used to be a link and it is causing nightmares now.
if [ -L %_includedir/scsi ]; then
	rm -f %_includedir/scsi
fi

%pre -n nscd
/usr/sbin/useradd -M -o -r -u 28 -d / -s /dev/null -c "NSCD Daemon" nscd ||:

%post -n nscd
%post_service nscd

%preun -n nscd
%preun_service nscd

%triggerpostun core -p /sbin/glibc_fix_nsswitch -- %name < 6:2.2.4-alt3, %name-nss < 6:2.2.4-alt4

%files

%files doc
%_infodir/*.info*
%docdir/

%files preinstall
/sbin/glibc_preinstall

%files core
/%_lib/lib*.so*
%exclude /%_lib/lib*thread*.so*
%exclude /%_lib/libanl*.so*
%exclude /%_lib/librt*.so*
/%_lib/ld*.so.*
%ifarch aarch64
/lib/ld-linux-aarch64.so.1
%endif
%ifarch riscv64
/lib/ld-linux-riscv64-lp64d.so.1
%endif
%attr(755,root,root)/%_lib/ld*.so
%exclude /%_lib/libnss_[a-eg-z]*
/sbin/glibc_post_upgrade
/sbin/glibc_fix_*
/sbin/*ldconfig
%_bindir/locale
%ghost %_sysconfdir/ld.so.cache
%dir %_sysconfdir/ld.so.conf.d
%dir %attr(700,root,root) %_cachedir/ldconfig
%ghost %verify(not md5 size mtime) %attr(600,root,root) %config(noreplace,missingok) %_cachedir/ldconfig/aux-cache
%ghost %verify(not md5 size mtime) %attr(644,root,root) %config(noreplace,missingok) %_sysconfdir/localtime
%config(noreplace) %_sysconfdir/bindresvport.blacklist
%config(noreplace) %_sysconfdir/gai.conf
%config(noreplace) %_sysconfdir/ld.so.conf
%config(noreplace) %_sysconfdir/nss.conf
%config(noreplace) %_sysconfdir/nsswitch.conf
%config(noreplace) %_sysconfdir/rpc

%files pthread
/%_lib/lib*thread*.so*
/%_lib/libanl*.so*
/%_lib/librt*.so*

%files nss
/%_lib/libnss_*.so*
%exclude /%_lib/libnss_f*

%files -n libnsl1
%_libdir/libnsl-*.so
%_libdir/libnsl.so.1

%if_with locales
%files locales -f libc.lang
%dir %_prefix/lib/locale
%if_disabled langify
%_prefix/lib/locale/*
%endif #disabled langify
%endif #with locales

%files gconv-modules
%dir %_gconvdir
%_gconvdir/*.so
%_gconvdir/gconv-modules
%ghost %verify(not md5 size mtime) %config(noreplace,missingok) %_gconvdir/gconv-modules.cache

%files -n iconv
%_bindir/iconv*
%_sbindir/iconv*

%files timezones
%_bindir/tzselect
%_sbindir/zdump
%_sbindir/zic

%files utils
/sbin/sln
%_bindir/*
%exclude %_bindir/iconv*
%exclude %_bindir/locale
%if_enabled memusagestat
%exclude %_bindir/memusage*
%endif
%exclude %_bindir/pcprofiledump
%exclude %_bindir/tzselect
%exclude %_bindir/xtrace
%_libexecdir/getconf
%_libdir/audit/sotruss-lib.so
%exclude /var/db/Makefile

%files devel -f devel.files
%_libdir/lib*.so
%exclude %_libdir/libnsl-*.so
%exclude %_libdir/libmemusage.so
%exclude %_libdir/libpcprofile.so
%_libdir/*.o
%_includedir/*

%files devel-static -f devel-static.files

%files debug
%if_enabled memusagestat
%_bindir/memusage*
%endif
%_bindir/pcprofiledump
%_bindir/xtrace
%_libdir/libmemusage.so
%_libdir/libpcprofile.so

%files -n nscd
%ghost %config(noreplace,missingok) /etc/sysconfig/nscd
%config(noreplace) %_sysconfdir/nscd.conf
%_initdir/nscd
%_unitdir/nscd.service
%_unitdir/nscd.socket
/lib/tmpfiles.d/nscd.conf
%_sbindir/nscd*
%attr(711,root,root) %dir /var/run/nscd
%attr(666,root,root) %ghost /var/run/nscd/socket
%attr(644,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/run/nscd/nscd.pid
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/run/nscd/passwd
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/run/nscd/group
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/run/nscd/hosts
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/run/nscd/services
%attr(1770,root,nscd) %dir /var/lib/nscd
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/lib/nscd/passwd
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/lib/nscd/group
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/lib/nscd/hosts
%attr(600,root,root) %ghost %config(noreplace,missingok) %verify(not md5 size mtime) /var/lib/nscd/services

%files i18ndata
%_datadir/i18n

%files source
%glibc_sourcedir

%changelog
