%def_disable snapshot

%define ver_major 3.40
%define xdg_name org.gnome.gnome-applets

%def_enable frequency_selector
%def_enable mini_commander
%def_enable battstat
%def_enable command
%def_enable timer
%def_enable tracker

Name: gnome-applets
Version: %ver_major.0
Release: alt1

Summary: Small applications for the GNOME panel
License: GPL-2.0 and GFDL-1.1
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Projects/GnomeApplets

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Source1: 01-cpufreq.pkla
Patch1: %name-3.22.0-alt-cpufreq_libs.patch

# From configure.ac
%define gtk_ver 3.20.0
%define glib_ver 2.44.0
%define gnome_panel_ver 3.38.0
%define libgtop_ver 2.12.0
%define libgail_ver 3.0
%define libxklavier_ver 4.0
%define libwnck_ver 2.9.3
%define libnotify_ver 0.7.1
%define icon_theme_ver 3.14
%define libgweather_ver 3.40
%define tracker_api_ver 3.0

Requires: gnome-panel >= %gnome_panel_ver
Requires: gvfs
%{?_enable tracker:Requires: tracker3}

Obsoletes: %name-common < 3.37
Provides: %name-common = %EVR
Obsoletes: %name-charpick < 3.37
Provides: %name-charpick = %EVR
Obsoletes: %name-drivemount < 3.37
Provides: %name-drivemount = %EVR
Obsoletes: %name-stickynotes < 3.37
Provides: %name-stickynotes = %EVR
Obsoletes: %name-geyes < 3.37
Provides: %name-geyes = %EVR
Obsoletes: %name-gweather < 3.37
Provides: %name-gweather = %EVR
Obsoletes: %name-multiload < 3.37
Provides: %name-multiload = %EVR
Obsoletes: %name-accessx-status < 3.37
Provides: %name-accessx-status = %EVR
Obsoletes: %name-netspeed < 3.37
Provides: %name-netspeed = %EVR
Obsoletes: %name-brightness < 3.37
Provides: %name-brightness = %EVR
Obsoletes: %name-inhibit < 3.37
Provides: %name-inhibit = %EVR
Obsoletes: %name-window-buttons < 3.37
Provides: %name-window-buttons = %EVR
Obsoletes: %name-window-title < 3.37
Provides: %name-window-title = %EVR
Obsoletes: %name-cpufreq-usermode < 3.37
Provides: %name-cpufreq-usermode = %EVR
%{?_enable tracker:
Obsoletes: %name-tracker-search-bar < 3.37
Provides: %name-tracker-search-bar = %EVR}
%{?_enable_frequency_selector:
Obsoletes: %name-cpufreq < 3.37
Provides: %name-cpufreq = %EVR}
%{?_enable_mini_commander:
Obsoletes: %name-mini-commander < 3.37
Provides: %name-mini-commander = %EVR}
%{?_enable_battstat:
Obsoletes: %name-battstat < 3.37
Provides: %name-battstat = %EVR}
%{?_enable_command:
Obsoletes: %name-command < 3.37
Provides: %name-command = %EVR}
%{?_enable_timer:
Obsoletes: %name-timer < 3.37
Provides: %name-timer = %EVR}

# From configure.ac
BuildRequires: autoconf-archive
#BuildRequires: intltool >= 0.35
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgnome-panel-devel >= %gnome_panel_ver
BuildRequires: libgtop-devel >= %libgtop_ver
BuildRequires: libgail3-devel >= %libgail_ver
BuildRequires: libxklavier-devel >= %libxklavier_ver
BuildRequires: libwnck3-devel >= %libwnck_ver
BuildRequires: libnotify-devel >= %libnotify_ver
BuildRequires: icon-theme-adwaita >= %icon_theme_ver
BuildRequires: libX11-devel libXt-devel
BuildRequires: libgucharmap-devel >= 2.33.2
BuildRequires: libgweather-devel >= %libgweather_ver
BuildRequires: rpm-build-gnome icon-theme-adwaita
BuildRequires: gnome-settings-daemon-devel
BuildRequires: libxml2-devel libdbus-devel
BuildRequires: libpolkit-devel xorg-cf-files yelp-tools
%{?_enable_battstat:BuildRequires: libupower-devel}
%{?_enable tracker:BuildRequires: pkgconfig(tracker-sparql-%tracker_api_ver)}
%{?_enable_frequency_selector:BuildRequires: libcpufreq-devel}

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System. The gnome-applets package provides
following small utilities for the GNOME panel:

battstat-applet is a utility that displays the status of the power
managment subsystem on laptops. It queries the APM BIOS and displays
remaining battery charge percentage in a graphical window.

charpick_applet allows you to easily write many characters which are not
available on standard keyboards such as accented  characters,  certain
mathematical  symbols and punctuation, and some other special symbols.

drivemount_applet allows to quickly and easily mount and unmount various
types of drives and file systems on computer.

geyes_applet is a pair of eyes which follow mouse pointer around the screen.

gweather displays the current temperature and weather conditions in
numeric and iconified form inside the applet.

mini_commander_applet adds a command line to your Panel. It features
command completion, command history, changeable macros and an optional
built-in clock. Because of the changeable macros you can use it for many
different tasks. You can simply start a program (or a short macro) or
view a web page or search for a man/info page etc.

multiload_applet contains 5 applets: CPU Load Applet, Load Average
Applet, Memory Load Applet, Net Load Applet and Swap Load Applet.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
    %{?_enable_mini_commander:--enable-mini-commander} \
    %{?_disable_battstat:--disable-battstat} \
    %{?_disable_frequency_selector:--disable-frequency-selector}
%nil
%make_build

%install
%makeinstall_std _sklocalstatedir=%buildroot%_sklocalstatedir
install -pD -m 644 %SOURCE1 %buildroot%_sysconfdir/polkit-1/localauthority/50-local.d/01-cpufreq.pkla
%define applets accessx-status battstat char-palette cpufreq-applet command-line drivemount gweather geyes stickynotes_applet multiload trashapplet netspeed_applet windowpicker brightness inhibit %{?_enable tracker:tracker-search-bar} window-buttons window-title
%find_lang --with-gnome --output=%name.lang %name %applets

%files -f %name.lang
%doc AUTHORS NEWS README
%_libdir/gnome-panel/modules/org.gnome.gnome-applets.so
%_datadir/%name
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_iconsdir/hicolor/*x*/*/*.png
%_iconsdir/hicolor/scalable/*/*.svg
%_datadir/dbus-1/system-services/org.gnome.CPUFreqSelector.service
%_datadir/glib-2.0/schemas/%xdg_name.charpick.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.cpufreq.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.gweather.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.multiload.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.netspeed.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.stickynotes.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.window-buttons.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.window-picker-applet.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.gnome-applets.window-title.gschema.xml
%_datadir/polkit-1/actions/org.gnome.cpufreqselector.policy
%_sysconfdir/dbus-1/system.d/org.gnome.CPUFreqSelector.conf
%_sysconfdir/polkit-1/localauthority/50-local.d/01-cpufreq.pkla
%config %_datadir/glib-2.0/schemas/%xdg_name.geyes.gschema.xml
%{?_enable_battstat:%_datadir/glib-2.0/schemas/%xdg_name.battstat.gschema.xml}
%{?_enable_command:%_datadir/glib-2.0/schemas/%xdg_name.command.gschema.xml}
%{?_enable_mini_commander:%_datadir/glib-2.0/schemas/%xdg_name.mini-commander.gschema.xml}
%{?_enable_timer:%_datadir/glib-2.0/schemas/%xdg_name.timer.gschema.xml}

%if_enabled frequency_selector
%attr(4711,root,root) %_bindir/cpufreq-selector
%endif

%exclude %_libdir/gnome-panel/modules/*.la

%changelog
