%def_disable snapshot
%define ver_major 40
%define beta %nil
%define api_ver 2
# GTK interface library
%define gci_api_ver 1
%define xdg_name org.gnome.Calculator
%define _libexecdir %_prefix/libexec

%def_enable check

Name: gnome-calculator
Version: %ver_major.1
Release: alt1%beta

Summary: GTK+3 based desktop calculator
License: GPL-3.0-or-later
Group: Sciences/Mathematics
Url: https://wiki.gnome.org/Apps/Calculator

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: gcalctool <= 6.6.2
Provides: gcalctool = 6.6.2
Requires: libgcalc = %EVR
Requires: libgci = %EVR

BuildRequires(pre): meson rpm-build-licenses rpm-build-gnome
BuildRequires: vala-tools >= 0.24 valadoc
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk+3-devel >= 3.20.0
BuildRequires: libgio-devel >= 2.50.0 libgee0.8-devel libxml2-devel
BuildRequires: libmpfr-devel libgtksourceview4-devel >= 4.8
BuildRequires: libsoup-devel >= 2.42 libmpc-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libgee0.8-gir-devel libsoup-gir-devel
BuildRequires: pkgconfig(libhandy-1)

%description
This package provides gcalctool, the calculator application that was
previously in the OpenWindows Deskset of the Solaris 8 operating system.

It incorporates a multiple precision arithmetic packages based on the work
of Professor Richard Brent.

A single graphics driver for GTK included with this package.


%package -n libgcalc
Summary: GNOME Calculator Library
Group: System/Libraries

%description -n libgcalc
This package contains shared GNOME Calculator library.

%package -n libgcalc-devel
Summary: Development files for libgcalc
Group: Development/C
Requires: libgcalc = %EVR

%description -n libgcalc-devel
This package development files for GNOME Calculator library.

%package -n libgcalc-gir
Summary: GObject introspection data for the GNOME Calculator library.
Group: System/Libraries
Requires: libgcalc = %EVR

%description -n libgcalc-gir
GObject introspection data for the GNOME Calculator library.

%package -n libgcalc-gir-devel
Summary: GObject introspection devel data for the GNOME Calculator library.
Group: Development/Other
BuildArch: noarch
Requires: libgcalc-devel = %EVR
Requires: libgcalc-gir = %EVR

%description -n libgcalc-gir-devel
GObject introspection devel data for the GNOME Calculator library.

%package -n libgcalc-devel-doc
Summary: Development documentation for the GNOME Calculator library
Group: Development/Documentation
Conflicts: libgcalc < %EVR
BuildArch: noarch

%description -n libgcalc-devel-doc
This package provides Development documentation for the GNOME Calculator library.

%package -n libgci
Summary: GNOME Calculator GTK Interface Library
Group: System/Libraries
Requires: libgcalc = %EVR

%description -n libgci
This package contains shared GNOME Calculator GTK interface library.

%package -n libgci-devel
Summary: Development files for libgci
Group: Development/C
Requires: libgci = %EVR

%description -n libgci-devel
This package development files for GNOME Calculator GTK interface library.

%package -n libgci-gir
Summary: GObject introspection data for the GNOME Calculator GTK interface library
Group: System/Libraries
Requires: libgci = %EVR

%description -n libgci-gir
GObject introspection data for the GNOME Calculator GTK interface library.

%package -n libgci-gir-devel
Summary: GObject introspection devel data for the GNOME Calculator GTK interface library.
Group: Development/Other
BuildArch: noarch
Requires: libgci-devel = %EVR
Requires: libgci-gir = %EVR

%description -n libgci-gir-devel
GObject introspection devel data for the GNOME Calculator GTK interface library.

%package -n libgci-devel-doc
Summary: Development documentation for the GNOME Calculator GTK interface library
Group: Development/Documentation
Conflicts: libgci < %EVR
BuildArch: noarch

%description -n libgci-devel-doc
This package provides Development documentation for the GNOME Calculator
GTK interface library.


%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_bindir/*
%_libexecdir/%name-search-provider
%_datadir/dbus-1/services/org.gnome.Calculator.SearchProvider.service
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_desktopdir/%xdg_name.desktop
%_man1dir/%name.1.*
%_man1dir/gcalccmd.1.*
%config %_datadir/glib-2.0/schemas/org.gnome.calculator.gschema.xml
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS README*

%files -n libgcalc
%_libdir/libgcalc-%api_ver.so.*

%files -n libgcalc-devel
%_includedir/gcalc-%api_ver/gcalc/
%_libdir/libgcalc-%api_ver.so
%_pkgconfigdir/gcalc-%api_ver.pc
%_vapidir/gcalc-%api_ver.deps
%_vapidir/gcalc-%api_ver.vapi

%files -n libgcalc-gir
%_typelibdir/GCalc-%api_ver.typelib

%files -n libgcalc-gir-devel
%_girdir/GCalc-%api_ver.gir

%files -n libgcalc-devel-doc
%_datadir/devhelp/books/GCalc-%api_ver/

%files -n libgci
%_libdir/libgci-%gci_api_ver.so.*

%files -n libgci-devel
%_includedir/gci-%api_ver
%_libdir/libgci-%gci_api_ver.so
%_pkgconfigdir/gci-%gci_api_ver.pc
%_vapidir/gci-%gci_api_ver.deps
%_vapidir/gci-%gci_api_ver.vapi

%files -n libgci-gir
%_typelibdir/GCi-%gci_api_ver.typelib

%files -n libgci-gir-devel
%_girdir/GCi-%gci_api_ver.gir

%files -n libgci-devel-doc
%_datadir/devhelp/books/GCi-%gci_api_ver/

%changelog
