%def_disable snapshot
%define optflags_lto %nil

%define _libexecdir %_prefix/libexec
%define _name control-center
%define ver_major 40
%define beta %nil
%define api_ver 2.0

%def_disable debug
%def_with cheese
%def_with bluetooth
%def_without snap
%def_with malcontent
%def_enable doc

Name: gnome-control-center
Version: %ver_major.9
Release: alt1%beta

Summary: GNOME Control Center
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://www.gnome.org

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%endif

%define gtk_ver 3.22.0
%define glib_ver 2.56.0
%define desktop_ver 3.33.4
%define fontconfig_ver 1.0.0
%define gsds_ver 3.37.1
# nm_client_get_permissions_state()
%define nm_ver 1.24
%define goa_ver 3.25.3
%define acc_ver 0.6.39
%define sett_daemon_ver 3.33.90
%define cheese_ver 3.9.5
%define bt_ver 3.18.2
%define systemd_ver 40
%define wacom_ver 0.7
%define ibus_ver 1.5.2
%define colord_ver 1.0
%define pwq_ver 1.2.2
%define upower_ver 0.99.8
%define grilo_ver 0.3.0
%define polkit_ver 0.114
%define snapd_ver 1.49
%define malcontent_ver 0.10.0
%define gudev_ver 232
%define pulse_ver 2.0
%define nahdy_ver 1.0

Requires: %name-data = %EVR

# For /usr/share/gnome
Requires: gnome-filesystem
Requires: gnome-settings-daemon >= %sett_daemon_ver
# for graphical passwd changing apps
Requires: accountsservice
#Requires: userpasswd
Requires: gnome-online-accounts >= %goa_ver
%{?_with_cheese:Requires: cheese >= %cheese_ver}

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildPreReq: meson desktop-file-utils gtk-doc xsltproc libappstream-glib-devel
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: gsettings-desktop-schemas-devel >= %gsds_ver
BuildPreReq: gnome-settings-daemon-devel >= %sett_daemon_ver
BuildPreReq: libcolord-devel >= %colord_ver
BuildPreReq: libcolord-gtk-devel
BuildPreReq: libsoup-devel
BuildPreReq: libibus-devel >= %ibus_ver libxkbfile-devel
BuildRequires: libupower-devel >= %upower_ver libpolkit1-devel >= %polkit_ver
BuildRequires: libgio-devel librsvg-devel libxml2-devel libcanberra-gtk3-devel
BuildRequires: libX11-devel libXext-devel libSM-devel libXScrnSaver-devel libXt-devel
BuildRequires: libXft-devel libXi-devel libXrandr-devel libXrender-devel libXcursor-devel libXcomposite-devel
BuildRequires: libgtop-devel libcups-devel libpulseaudio-devel >= %pulse_ver iso-codes-devel
BuildRequires: libpwquality-devel >= %pwq_ver  libkrb5-devel libsmbclient-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
# for test-endianess
BuildRequires: glibc-i18ndata
BuildRequires: libnm-devel >= %nm_ver libmm-glib-devel libnma-devel
BuildRequires: libgnome-online-accounts-devel >= %goa_ver
BuildRequires: libaccountsservice-devel >= %acc_ver
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: libclutter-gtk3-devel
BuildRequires: pkgconfig(systemd) >= %systemd_ver
BuildRequires: libgrilo-devel >= %grilo_ver
BuildRequires: libsecret-devel
BuildRequires: libudisks2-devel
%{?_with_cheese:BuildPreReq: libcheese-devel >= %cheese_ver}
%{?_with_bluetooth:BuildRequires: libgnome-bluetooth-devel >= %bt_ver}
%{?_with_snap:BuildRequires: lisnapd-glib-devel >= %snapd_ver}
%{?_with_malcontent:BuildRequires: pkgconfig(malcontent-0) >= %malcontent_ver}
BuildRequires: libgudev-devel >= %gudev_ver libgsound-devel
BuildRequires: pkgconfig(libhandy-1) >= %nahdy_ver
BuildRequires: libepoxy-devel

%description
GNOME (the GNU Network Object Model Environment) is an attractive and
easy-to-use GUI desktop environment. The control-center package
provides the GNOME Control Center utilities that allow you to setup
and configure your system's GNOME environment (things like the desktop
background and theme, the screensaver, the window manager, system
sounds, and mouse behavior).

If you install GNOME, you need to install control-center.

%package data
Summary: Arch independent files for GNOME Control Center
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for GNOME Control Center to work.

%package devel
Summary: GNOME Control Center development files
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name = %EVR

%description devel
If you're interested in developing panels for the GNOME control center,
you'll want to install this package.

%name-devel helps you create the panels for the control center.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{?_with_cheese:-Dcheese=true} \
    %{?_with_snap:-Dsnap=true} \
    %{?_with_malcontent:-Dmalcontent=true} \
    %{?_enable_doc:-Ddocumentation=true}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name-%api_ver %name-%api_ver-timezones %_name

%files
%_bindir/%name
%_libexecdir/cc-remote-login-helper
%_libexecdir/%name-search-provider
%_libexecdir/%name-print-renderer

%files data -f %name.lang
%dir %_datadir/%name
%_datadir/%name/keybindings
%_datadir/%name/pixmaps
%_desktopdir/*.desktop
%_datadir/pixmaps/faces/
%_iconsdir/hicolor/*/*/*
%_datadir/sounds/gnome/default/alerts/*.ogg
%_datadir/glib-2.0/schemas/org.gnome.ControlCenter.gschema.xml
%_datadir/polkit-1/actions/org.gnome.controlcenter.datetime.policy
%_datadir/polkit-1/actions/org.gnome.controlcenter.user-accounts.policy
%_datadir/polkit-1/rules.d/gnome-control-center.rules
%_datadir/polkit-1/actions/org.gnome.controlcenter.remote-login-helper.policy
%_datadir/dbus-1/services/org.gnome.ControlCenter.SearchProvider.service
%_datadir/dbus-1/services/org.gnome.ControlCenter.service
%_datadir/gnome-shell/search-providers/gnome-control-center-search-provider.ini
%{?_enable_doc:%_man1dir/%name.1.*}
%_datadir/bash-completion/completions/gnome-control-center
%_datadir/metainfo/%name.appdata.xml
%doc NEWS README*

%files devel
%_datadir/pkgconfig/gnome-keybindings.pc
%_datadir/gettext/its/gnome-keybindings.its
%_datadir/gettext/its/gnome-keybindings.loc
%_datadir/gettext/its/sounds.its
%_datadir/gettext/its/sounds.loc


%changelog
