%define git f528107

%def_enable systemd
%def_enable man
%def_disable consolekit
%def_disable elogind


Name: gnome-firmware
Version: 3.36.0
Release: alt0.1.g%{git}
Summary: Install firmware on devices
Group: System/Configuration/Hardware
License: GPLv2
Url: https://gitlab.gnome.org/hughsie/gnome-firmware-updater
Source0: %name-%version.tar.gz
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires: libgtk+3-devel libgio-devel fwupd-devel libxmlb-devel
%{?_enable_systemd:BuildRequires: libsystemd-devel}
%{?_enable_man:BuildRequires: help2man}
%{?_enable_consolekit:BuildRequires: libConsoleKit-devel}
%{?_enable_elogind:BuildRequires: libelogind-devel}

%description
GNOME Firmware application can:

- Upgrade, Downgrade, & Reinstall firmware on devices supported by fwupd.
- Unlock locked fwupd devices
- Verify firmware on supported devices
- Display all releases for a fwupd device

%prep
%setup
%patch -p1

%build
export LIB=%_lib
%meson \
	%{?_disable_systemd:-Dsystemd=false} \
	%{?_disable_man:-Dman=false} \
	%{?_disable_consolekit:-Dconsolekit=false} \
	%{?_disable_elogind:-Delogind=false}
%nil
%meson_build

%install
%meson_install
%find_lang %{name}

%files -f %{name}.lang
%doc README* COPYING
%_bindir/*
%_datadir/metainfo/org.gnome.Firmware.metainfo.xml
%_desktopdir/*.desktop
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/symbolic/apps/*.svg
%_man1dir/*

%changelog
