%define _unpackaged_files_terminate_build 1

%define _name klotski
%define xdg_name org.gnome.Klotski
%define __name gnome-%_name
%define ver_major 3.38
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt1

Summary: Derivative game from Klotski
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Klotski

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %__name = %version-%release
Obsoletes: gnome-games-gnotski
Provides:  gnome-games-gnotski = %version-%release

%define glib_ver 2.40.0
%define gtk_ver 3.22.0

BuildRequires(pre): meson
BuildRequires: vala-tools
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libgee0.8-devel libgnome-games-support-devel
BuildRequires: librsvg-devel

%description
Gnome Klotski is a small game for GNOME. The idea is originally
from a game called "Klotski".

%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%attr(2711,root,games) %_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_man6dir/%__name.*
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml


%changelog
