%def_enable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name mines
%define __name gnome-%_name
%define ver_major 40
%define xdg_name org.gnome.Mines

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt2

Summary: Classic find the mines in the minefield game
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Mines

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz
%else
Source: %__name-%version.tar
%endif

Provides:  %__name = %EVR
Obsoletes: gnome-games-gnomine
Provides:  gnome-games-gnomine = %EVR

%define glib_ver 2.40.0
%define gtk_ver 3.22.23

BuildRequires(pre): meson
BuildRequires: vala-tools
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel
BuildRequires: libgnome-games-support-devel

%description
NOME Mines is a variation of the popular logic puzzle minesweeper.

%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name/
%_iconsdir/hicolor/*/apps/*.svg
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
