%define _unpackaged_files_terminate_build 1
%def_enable snapshot

%define _name nibbles
%define __name gnome-%_name
%define xdg_name org.gnome.Nibbles
%define ver_major 3.38
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt2

Summary: A cute little game that has no short description
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Nibbles

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz
%else
Source: %__name-%version.tar
%endif

Provides:  %__name = %version-%release
Obsoletes: gnome-games-gnibbles
Provides:  gnome-games-gnibbles = %version-%release

%define glib_ver 2.32.0
%define gtk_ver 3.4.0
%define clutter_ver 1.14.4

BuildRequires(pre): meson
BuildRequires: yelp-tools gsettings-desktop-schemas-devel libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel
BuildRequires: libgsound-devel libclutter-devel >= %clutter_ver libclutter-gtk3-devel
BuildRequires: libgnome-games-support-devel >= 1.8.0

%description
Gnibbles is a game where the user controls a snake. The snake moves
around the board, eating diamonds while avoiding the walls placed around
it.


%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%attr(2711,root,games) %_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
