%def_disable snapshot

%define ver_major 40
%define beta %nil
%define domain gcampax.github.com
%define _libexecdir %_prefix/libexec

%def_enable classic_mode

Name: gnome-shell-extensions
Version: %ver_major.7
Release: alt1%beta

Summary: GNOME Shell Extensions
Group: Graphical desktop/GNOME
License: GPLv2+
Url: https://wiki.gnome.org/Projects/GnomeShell

BuildArch: noarch

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: gnome-shell >= %version

# extensions/apps-menu/extension.js
# const {
#     Atk, Clutter, Gio, GLib, GMenu, GObject, Gtk, Meta, Shell, St
# } = imports.gi;
%{?_enable_classic_mode:Requires: typelib(GMenu) = 3.0}

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson libgjs-devel libmozjs78-tools sassc

%description
GNOME Shell Extensions is a collection of extensions providing additional
and optional functionality to GNOME Shell.
See %_docdir/%name-%version/README for more information.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{?_enable_classic_mode:-Dclassic_mode=true} \
    -Dextension_set=all
%meson_build

%check
%meson_test

%install
%meson_install
%find_lang %name

%files -f %name.lang
# Classic mode
%if_enabled classic_mode
#%_datadir/gnome-session/sessions/gnome-classic.session
%_datadir/xsessions/gnome-classic.desktop
%_datadir/gnome-shell/modes/classic.json
%_datadir/gnome-shell/theme/calendar-today.svg
%_datadir/gnome-shell/theme/classic-toggle-off-intl.svg
%_datadir/gnome-shell/theme/classic-toggle-off-us.svg
%_datadir/gnome-shell/theme/classic-toggle-on-intl.svg
%_datadir/gnome-shell/theme/classic-toggle-on-us.svg
%_datadir/gnome-shell/theme/classic-process-working.svg
%_datadir/gnome-shell/theme/gnome-classic.css
%_datadir/gnome-shell/theme/gnome-classic-high-contrast.css
%_datadir/glib-2.0/schemas/00_org.gnome.shell.extensions.classic.gschema.override
%endif

## Extensions
%dir %_datadir/gnome-shell/extensions
# windowsNavigator
%dir %_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/stylesheet.css

# auto-move-windows
%dir %_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/prefs.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.auto-move-windows.gschema.xml

# user theme loading
%dir %_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/prefs.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/util.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.user-theme.gschema.xml

# removable drives menu
%dir %_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/stylesheet.css

# apps-menu
%dir %_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/stylesheet.css

# native-window-placement
%dir %_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.native-window-placement.gschema.xml

# places-menu
%dir %_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/placeDisplay.js

# workspace indicator
%dir %_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/prefs.js

# launch-new-instance
%dir %_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/stylesheet.css

# window-list
%dir %_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/classic.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/prefs.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/windowPicker.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/workspaceIndicator.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.window-list.gschema.xml

# screenshot-window-sizer
%dir %_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.screenshot-window-sizer.gschema.xml
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/stylesheet.css

%doc NEWS README.md

%changelog
