# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_disable docs
%def_enable tests

%define _libexec %prefix/libexec

Name: gnuradio
Version: 3.9.1.0
Release: alt1
Summary: Software defined radio framework
License: GPLv2+
Group: Engineering
Url: http://www.gnuradio.org
Packager: Anton Midyukov <antohami@altlinux.org>

Source: %name-%version.tar
Patch0: fix-gnuradio-qtgui.pc.patch
Patch1: gnuradio-3.9.1.0-python3-fix.patch

%add_python3_path %_datadir/%name

BuildRequires(pre): rpm-macros-cmake rpm-macros-python3
BuildRequires: rpm-build-python3 rpm-build-gir
BuildRequires: gcc-c++ cmake
BuildRequires: liborc-devel
BuildRequires: libgtk+3-gir-devel
BuildRequires: libgmpxx-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-interprocess-devel
BuildRequires: boost-program_options-devel
BuildRequires: libgsm-devel
BuildRequires: qt5-base-devel
BuildRequires: liblog4cpp-devel
BuildRequires: mpir-devel
BuildRequires: libqwt6-qt5-devel
BuildRequires: libzeromq-cpp-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(codec2)
BuildRequires: pkgconfig(comedilib)
BuildRequires: pkgconfig(fftw3f)
BuildRequires: pkgconfig(gsl)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(portaudio-2.0)
#BuildRequires: pkgconfig(thrift)
BuildRequires: pkgconfig(uhd)
BuildRequires: libSDL-devel
BuildRequires: libvolk-devel
BuildRequires: python3-devel
BuildRequires: python3-module-yaml
BuildRequires: python3-module-mako
BuildRequires: python3-module-lxml
BuildRequires: python3-module-numpy
BuildRequires: python3-module-pygobject3-devel
BuildRequires: python3-module-pycairo-devel
BuildRequires: python3-module-PyQt5
BuildRequires: python3-module-click-plugins
BuildRequires: python3-module-pyqtgraph
BuildRequires: python3-module-scipy-devel
BuildRequires: pybind11-devel
BuildRequires: libsndfile-devel
BuildRequires: libunwind-devel
BuildRequires: mpir-devel
BuildRequires: libgmp-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: doxygen

%if_enabled tests
BuildRequires: pkgconfig(cppunit)
%endif #tests
%if_enabled docs
BuildRequires: doxygen python3-module-sphinx
BuildRequires: /usr/bin/latex /usr/bin/dvips tex(dvips.def)
%endif #docs
BuildRequires: desktop-file-utils xdg-utils
%add_python3_req_skip PyQt5.Qwt
%add_python3_req_skip gnuradio.ctrlport.GNURadio

Obsoletes: gnuradio-data < 3.8
Obsoletes: libgnuradio < 3.8

%description
GNU Radio is a collection of software that when combined with minimal
hardware, allows the construction of radios where the actual waveforms
transmitted and received are defined by software. What this means is
that it turns the digital modulation schemes used in today's high
performance wireless devices into software problems.

%package docs
Summary: GNU Radio Documentation
Group: Engineering
Buildarch: noarch
Requires: %name = %EVR

%description docs
GNU Radio Documentation.

%package examples
Summary: GNU Radio Examples
Group: Engineering
Buildarch: noarch
Requires: %name = %EVR
%add_findreq_skiplist %_datadir/%name/examples/*.grc

%description examples
GNU Radio Examples.

%package devel
Group: Development/C++
Summary: GNU Radio Headers
Requires: %name = %EVR
Requires: cmake boost-program_options-devel
Provides: libgnuradio-devel = %EVR

%description devel
GNU Radio Headers.

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%cmake \
	-DENABLE_INTERNAL_VOLK=OFF \
	-DGR_PYTHON_DIR=%python3_sitelibdir \
	-DPYTHON_EXECUTABLE=%__python3 \
%if_enabled tests
	-DENABLE_TESTING=ON
%else
	-DENABLE_TESTING=OFF
%endif #tests
%cmake_build

%install
%cmakeinstall_std

# Remove extraneous desktop/icon/mime files
rm -r %buildroot%_datadir/%name/grc/freedesktop
#rm -r %buildroot%_datadir/icons/gnome

# remove verify_elf problem files
rm %buildroot%_datadir/%name/examples/audio/dial_tone
rm %buildroot%_datadir/%name/examples/qt-gui/display_qt
rm %buildroot%_datadir/%name/examples/uhd/tags_demo

# fix *.grc files permissions
find %buildroot%_datadir/ -name '*.grc' | xargs \
	chmod 644

# fix shebang
find %buildroot%_datadir/%name -name '*.py' | xargs sed -i \
	-e 's:/usr/bin/env python$:%__python3:'

%files
%_bindir/*
%_sysconfdir/%name
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*.desktop
%_datadir/mime/packages/*
%_libdir/*.so.*
%_libexec/%name
%_datadir/%name
%exclude %_datadir/%name/examples
%_docdir/%name-%version
%python3_sitelibdir/%name
%python3_sitelibdir/pmt
%if_enabled docs
%exclude %_docdir/%name-%version/xml
%exclude %_docdir/%name-%version/html
%endif #docs
%_datadir/metainfo/org.gnuradio.grc.metainfo.xml

%if_enabled docs
%files docs
%_docdir/%name-%version/xml
%_docdir/%name-%version/html
%endif #docs

%files examples
%_datadir/%name/examples

%files devel
%_libdir/*.so
%_libdir/cmake/%name
%_includedir/%name
%_includedir/pmt
%_pkgconfigdir/*.pc

%changelog
