# need because asm used
%set_verify_elf_method textrel=relaxed
%def_without opts
%def_with clang

%define oname objc2

Name: gnustep-%oname
Version: 2.1
Release: alt1
Summary: GNUstep Objective-C Runtime
License: BSD
Group: Development/Objective-C
Url: http://www.gnustep.org/
Packager: Andrey Cherepanov <cas@altlinux.org>

# http://svn.gna.org/svn/gnustep/libs/libobjc2/trunk/
Source: lib%oname-%version.tar
Source1: robin-map.tar
Patch: objc2-fix-generate-eh_trampoline.s.patch

ExcludeArch: armh

BuildRequires(pre): rpm-macros-make
BuildRequires(pre): cmake
BuildRequires: gcc-objc gcc-c++ libstdc++-devel
%if_with clang
BuildRequires: clang-devel
BuildRequires: llvm-devel
%endif

%description
The GNUstep Objective-C runtime is designed as a drop-in replacement for
the GCC runtime.  It supports both a legacy and a modern ABI, allowing
code compiled with old versions of GCC to be supported without requiring
recompilation.

%package -n lib%name
Summary: Shared libraries of GNUstep Objective-C Runtime
Group: System/Libraries

%description -n lib%name
The GNUstep Objective-C runtime is designed as a drop-in replacement for
the GCC runtime.  It supports both a legacy and a modern ABI, allowing
code compiled with old versions of GCC to be supported without requiring
recompilation.

This package contains shared libraries of GNUstep Objective-C Runtime.

%package -n lib%name-devel
Summary: Development files of GNUstep Objective-C Runtime
Group: Development/Objective-C
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-devel
The GNUstep Objective-C runtime is designed as a drop-in replacement for
the GCC runtime.  It supports both a legacy and a modern ABI, allowing
code compiled with old versions of GCC to be supported without requiring
recompilation.

This package contains development files of GNUstep Objective-C Runtime.

%if_with opts
%package -n lib%name-opts
Summary: Shared libraries of GNUstep Runtime Optimisations
Group: System/Libraries

%description -n lib%name-opts
The GNUstep Objective-C runtime is designed as a drop-in replacement for
the GCC runtime.  It supports both a legacy and a modern ABI, allowing
code compiled with old versions of GCC to be supported without requiring
recompilation.

This package contains shared libraries of GNUstep Runtime Optimisations.

%package -n lib%name-opts-devel
Summary: Development files of GNUstep Runtime Optimisations
Group: Development/Objective-C
Requires: lib%name-opts = %version-%release

%description -n lib%name-opts-devel
The GNUstep Objective-C runtime is designed as a drop-in replacement for
the GCC runtime.  It supports both a legacy and a modern ABI, allowing
code compiled with old versions of GCC to be supported without requiring
recompilation.

This package contains development files of GNUstep Runtime Optimisations.
%endif

%prep
%setup -n lib%oname-%version
%patch -p1
tar xf %SOURCE1
%if_without clang
# Remove Xclang unsupported by gcc
subst 's/ -Xclang//g' CMakeLists.txt Test/CMakeLists.txt
%endif
cp -fR objc objc2
#chmod +x build_opts.sh

%build
#./build_opts.sh
%add_optflags -I$PWD %optflags_shared -fpermissive
%add_optflags -D__STDC_LIMIT_MACROS -D__STDC_CONSTANT_MACROS
export CPPFLAGS="%optflags"
cmake \
	-DLIB_SUFFIX:STRING=%_libsuff \
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DCMAKE_ASM_FLAGS:STRING="%optflags" \
%if_with clang
	-DCMAKE_ASM_COMPILER:FILEPATH='%_bindir/clang' \
	-DCMAKE_C_COMPILER:FILEPATH='%_bindir/clang' \
	-DCMAKE_CXX_COMPILER:FILEPATH='%_bindir/clang++' \
%else
	-DCMAKE_ASM_COMPILER:FILEPATH='%_bindir/cc' \
	-DCMAKE_C_COMPILER:FILEPATH='%_bindir/cc' \
	-DCMAKE_CXX_COMPILER:FILEPATH='%_bindir/g++' \
%endif
	-DLLVM_DIR:PATH='%_datadir/cmake/Modules' \
	-DCMAKE_STRIP:FILEPATH='/bin/true' \
	-DCPACK_STRIP_FILES:BOOL=OFF \
	-DCXX_RUNTIME:FILEPATH='-lpthread -lstdc++' \
	-DGNUSTEP_INSTALL_TYPE:STRING='NONE' \
	-DCMAKE_INSTALL_LIBDIR:STRING='%_lib' \
	-DINCLUDE_DIRECTORY:STRING=objc2 \
	-DLEGACY_COMPAT:BOOL=ON \
	-DLIBOBJC_NAME:STRING=objc2 \
%if_with clang
	-DLLVM_ON_UNIX:BOOL=ON \
%else
	-DLLVM_ON_UNIX:BOOL=OFF \
%endif
	-DLLVM_OPTS:BOOL=FALSE \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DTESTS:BOOL=OFF \
	.

%make_build_ext \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes \
	PREFIX=%prefix \
	LIB_DIR=%_libdir \
	HEADER_DIR=%_includedir

%install
rm -f GNUmakefile
%makeinstall_std \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes \
	install
#	PREFIX=%buildroot%prefix \
#	LIB_DIR=%buildroot%_libdir \
#	HEADER_DIR=%buildroot%_includedir \

sed -i 's|#include "visibility.h"|#include "objc2/visibility.h"|' \
	class.h
#install -p -m644 class.h visibility.h method_list.h ivar.h protocol.h \
#	selector.h sarray2.h category.h \
#	%buildroot%_includedir/objc2/

ln -s objc2 %buildroot%_includedir/objc

%files -n lib%name
%doc ANNOUNCE* API README.md
%_libdir/*.so.*
%if_with opts
%exclude %_libdir/libGNUObjCRuntime.so.*
%endif

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%if_with opts
%exclude %_includedir/objc2/opts
%exclude %_libdir/libGNUObjCRuntime.so
%endif
%_pkgconfigdir/libobjc.pc

%if_with opts
%files -n lib%name-opts
%doc opts/README
%_libdir/libGNUObjCRuntime.so.*

%files -n lib%name-opts-devel
%_includedir/objc2/opts
%_libdir/libGNUObjCRuntime.so
%endif

%changelog
