%define libgnutls_soname 30
%define libgnutlsxx28_soname 28
%define libgnutls_openssl_soname 27

Name: gnutls%libgnutls_soname
Version: 3.6.16
Release: alt8

Summary: A TLS protocol implementation
# The libgnutls library is LGPLv2.1+, utilities and remaining libraries are GPLv3+
License: LGPLv2.1+ and GPLv3+
Group: System/Libraries
Url: https://gnutls.org/
# ftp://ftp.gnutls.org/pub/gnutls/gnutls-%version.tar.bz2
Source: gnutls-%version.tar

Patch3: Fix-privkey-verify-broken-test.patch
Patch4: tests-Use-IPv4-only-in-s_server.patch
Patch6: gnulib-E2K-fix-for-lcc-1.23.patch
Patch8: fix-32bit-LTS.patch
Patch9: fix_gl_tests.patch
Patch10: Fix-double-free-during-gnutls_pkcs7_verify.patch
Patch11: auth-rsa-side-step-potential-side-channel.patch
Patch12: rsa-remove-dead-code.patch
Patch13: CVE-2023-5981.patch
Patch14: CVE-2024-0567.patch
Patch15: CVE-2024-0553.patch
Patch16: test-for-CVE-2024-28835.patch
Patch17: CVE-2024-28834.patch
Patch18: CVE-2021-4209.patch
Patch19: CVE-2024-12243.patch
Patch20: CVE-2025-32990.patch
Patch21: CVE-2025-32988.patch
Patch22: psk-fix-read-buffer-overrun-in-the-pre_shared_key-ex.patch
Patch23: x509-reject-zero-length-version-in-certificate-reque.patch
Patch24: CVE-2025-6395.patch

%define libcxx libgnutlsxx%libgnutlsxx28_soname
%define libssl libgnutls%{libgnutls_openssl_soname}-openssl
%def_enable guile
#set_automake_version 1.11

# Automatically added by buildreq on Thu Dec 08 2011
BuildRequires: gcc-c++ gtk-doc libgcrypt-devel libp11-kit-devel libreadline-devel libtasn1-devel makeinfo zlib-devel
BuildRequires: autogen libopts-devel libidn2-devel libunistring-devel
BuildRequires: libnettle-devel >= 3.4.1-alt1
%if_enabled guile
# Unfortunately we have different version
# on e2k and don't have guile-devel.
# See https://bugzilla.altlinux.org/34496
%ifarch %e2k
BuildRequires: guile20-devel
BuildRequires: libguile20-devel
%else
BuildRequires: guile22-devel
%endif
%endif

# For tests
%{?!_without_check:%{?!_disable_check:BuildRequires: net-tools}}
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}
%{?!_without_check:%{?!_disable_check:BuildRequires: datefudge}}
# tests/pkcs11/tls-neg-pkcs11-key.c doesn't work with softhsm-2.1.0:
%{?!_without_check:%{?!_disable_check:BuildRequires: softhsm >= 2.4.0}}
%{?!_without_check:%{?!_disable_check:BuildRequires: openssl}}
%{?!_without_check:%{?!_disable_check:BuildRequires: libssl-devel}}
%{?!_without_check:%{?!_disable_check:BuildRequires: socat}}
%{?!_without_check:%{?!_disable_check:BuildRequires: ppp}}
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}
%ifnarch %e2k
# no libseccomp on e2k for now
%{?!_without_check:%{?!_disable_check:BuildRequires: libseccomp-devel}}
%endif

%description
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

%package -n lib%name
Summary: Transport Layer Security library
License: LGPLv2.1+
Group: System/Libraries
Provides: libgnutls = %version
Obsoletes: libgnutls < %version
Obsoletes: libgnutls-new < %version

%description -n lib%name
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS runtime library.

%package -n libgnutls-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release
Obsoletes: libgnutls-new-devel < %version

%description -n libgnutls-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build GnuTLS-based software.

%package -n %libcxx
Summary: Transport Layer Security C++ library
Group: System/Libraries
License: GPLv3+
Requires: lib%name = %version-%release
Provides: libgnutlsxx = %version
Obsoletes: libgnutlsxx < %version
Obsoletes: libgnutls-newxx < %version

%description -n %libcxx
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS C++ runtime library.

%package -n libgnutlsxx-devel
Summary: Development files for libgnutlsxx
Group: Development/C++
Requires: %libcxx = %version-%release
Requires: libgnutls-devel = %version-%release
Obsoletes: libgnutls-newxx-devel < %version

%description -n libgnutlsxx-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build GnuTLS-based software using C++.

%package -n %libssl
Summary: OpenSSL compatibility layer for the GnuTLS library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: libgnutls-openssl = %version
Obsoletes: libgnutls-openssl < %version
Obsoletes: libgnutls-new-openssl < %version

%description -n %libssl
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS runtime OpenSSL compatibility library.

%package -n libgnutls-openssl-devel
Summary: Development files for %libssl
Group: Development/C
Requires: %libssl = %version-%release
Requires: libgnutls-devel = %version-%release
Obsoletes: libgnutls-new-openssl-devel < %version

%description -n libgnutls-openssl-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build applications using the GnuTLS compatibility OpenSSL library.

%package -n gnutls-utils
Summary: TLS protocol utilities
Group: Security/Networking
Obsoletes: gnutls-utils26 < %version-%release
Obsoletes: gnutls-utils28 < %version-%release

%description -n gnutls-utils
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains command line TLS client and server, and
certificate manipulation tools.

%package -n libgnutls-guile
Summary: GnuTLS Guile bindings
Group: Development/Other
Requires: lib%name = %version-%release
Obsoletes: libgnutls-new-guile < %version

%description -n libgnutls-guile
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains Guile bindings for the library.

%package devel-doc
Summary: Development documentation for GnuTLS
Group: Development/C
Conflicts: libgnutls-devel < %version
Provides: gnutls-devel-doc = %version
Obsoletes: gnutls-devel-doc < %version
Obsoletes: gnutls-new-devel-doc < %version
BuildArch: noarch

%description devel-doc
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS API Reference Manual.

%prep
%setup -n gnutls-%version
%patch3 -p2

# We have two gnulib sources.
# Just apply patch twice for both src/gl/ and gl/.
pushd src/gl
%patch6 -p4
popd
pushd gl
%patch6 -p4
popd

%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

touch doc/*.texi
rm doc/*.info*
rm aclocal.m4 m4/{libtool,lt*}.m4
# Thanks to USE_POSIX_THREADS_WEAK feature, we have to link
# tests with @LIBMULTITHREAD@ in --no-as-needed mode.
sed -i 's/^\(test_[^ +=]\+\)_LDADD.*@LIBMULTITHREAD@.*/&\n\1_LDFLAGS = -Wl,--no-as-needed/' gl/tests/Makefile.*
# Use soname in the names of locale files
sed -i -r 's/^DOMAIN = [^[:blank:]#]+/&%libgnutls_soname/' po/Makevars

%build
%autoreconf
%def_disable static
%configure \
	--disable-rpath \
	--disable-static \
	--disable-silent-rules \
	--disable-libdane  \
	--without-tpm \
	--with-default-trust-store-file=/usr/share/ca-certificates/ca-bundle.crt \
	%{subst_enable guile} \
	--disable-local-libopts \
	--with-included-libtasn1=no \
	--enable-openssl-compatibility \
	--with-libidn2 \
	--docdir=%_docdir/gnutls-%version/
make MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
find %buildroot%_infodir/ -name '*.png' -delete -print
%define docdir %_docdir/gnutls-%version
mkdir -p %buildroot%docdir/{examples,reference}
install -p -m644 AUTHORS NEWS README.md THANKS %buildroot%docdir/
install -p -m644 doc/*.{cfg,css,html,png} %buildroot%docdir/
install -pm644 doc/examples/*.[hc]* %buildroot%docdir/examples/
install -pm644 doc/reference/html/* %buildroot%docdir/reference/
ln -s %_licensedir/GPL-2 %buildroot%docdir/COPYING
ln -s %_licensedir/LGPL-2.1 %buildroot%docdir/COPYING.LIB

%find_lang gnutls%libgnutls_soname
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
# The option inserted by the patch is unknown in older openssl:
if openssl s_server --help 2>&1 | grep -Ewe '^[[:blank:]]*-4'; then
   patch -p2 < %PATCH4
fi
make -k check

%files -n lib%name -f gnutls%libgnutls_soname.lang
%dir %docdir
%docdir/[ACNRT]*
%_libdir/libgnutls.so.*

%files -n %libcxx
%_libdir/libgnutlsxx.so.*

%files -n %libssl
%_libdir/libgnutls-openssl.so.*

%files -n libgnutls-devel
%_includedir/gnutls/
%exclude %_includedir/gnutls/gnutlsxx.h
%exclude %_includedir/gnutls/openssl.h
%_libdir/libgnutls.so
%_pkgconfigdir/gnutls.pc

%files -n libgnutlsxx-devel
%dir %_includedir/gnutls/
%_includedir/gnutls/gnutlsxx.h
%_libdir/libgnutlsxx.so


%files -n libgnutls-openssl-devel
%dir %_includedir/gnutls/
%_includedir/gnutls/openssl.h
%_libdir/libgnutls-openssl.so

%files devel-doc
%dir %docdir
%docdir/*.css
%docdir/*.html
%docdir/*.png
%docdir/examples/
%docdir/reference/
%_man3dir/*
%_infodir/*

%files -n gnutls-utils
%_bindir/*
%_man1dir/*
%dir %docdir
%docdir/*.cfg

%if_enabled guile
%files -n libgnutls-guile
%_libdir/guile/*/extensions/guile*.so*
%_libdir/guile/*/site-ccache/*
%_datadir/guile/site/*/*
%exclude %_libdir/guile/*/extensions/*.la
%endif

%changelog
