%define _unpackaged_files_terminate_build 1
%define buildpath $PWD/.build

%define import_path github.com/BurntSushi/toml-test

Name: golang-github-burntsushi-toml-test
Version: 1.2.0
Release: alt1

Summary: Language agnostic test suite for TOML
License: MIT
Group: Development/Other
Url: https://github.com/BurntSushi/toml-test.git

Source0: %name-%version.tar
Source1: vendor.tar

BuildRequires(pre): rpm-build-golang

Provides: toml-test = %EVR

%description
toml-test is a higher-order program that tests other TOML decoders or
encoders. Tests are divided into two groups: invalid TOML data and valid TOML
data. Decoders that reject invalid TOML data pass invalid TOML tests. Decoders
that accept valid TOML data and output precisely what is expected pass valid
tests.

%prep
# run `go mod vendor` to update vendored sources
%setup -a1

%build
export BUILDDIR="%buildpath"
export IMPORT_PATH="%import_path"
%golang_prepare

%golang_build cmd/*

%install
export BUILDDIR="%buildpath"
export IGNORE_SOURCES=1

%golang_install

mkdir -p %buildroot%_datadir/toml-test
cp -a tests %buildroot%_datadir/toml-test/

%files
%doc COPYING README.md
%_bindir/toml-test
%_datadir/toml-test/

%changelog
