%define _unpackaged_files_terminate_build 1

Name: goldendict
Version: 1.5.0
Release: alt3

Summary: Feature-rich dictionary lookup program
License: GPL-3.0
Group: Education
URL: http://www.goldendict.org
VCS: https://github.com/goldendict/goldendict

Source0: %name-%version.tar
Patch0: goldendict-ru-desktop.patch
Patch1: goldendict-remove-git-version.patch
Patch2: goldendict-1.5.0-alt-link-config.patch

BuildRequires(pre): qt5-base-devel
BuildRequires: bzlib-devel
BuildRequires: eb-devel
BuildRequires: gcc-c++
BuildRequires: libX11-devel
BuildRequires: libXtst-devel
BuildRequires: libao-devel
BuildRequires: libavformat-devel
BuildRequires: libavutil-devel
BuildRequires: libhunspell-devel
BuildRequires: liblzo2-devel
BuildRequires: libtiff-devel
BuildRequires: libvorbis-devel
BuildRequires: libzip-devel
BuildRequires: qt5-multimedia-devel
BuildRequires: qt5-phonon-devel
BuildRequires: qt5-script-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools
BuildRequires: qt5-tools-devel
BuildRequires: qt5-webkit-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: libswresample-devel

%description
GoldenDict is feature-rich dictionary lookup program. Features:
* Use of WebKit for an accurate articles' representation, complete with
  all formatting, colors, images and links.
* Support of multiple dictionary file formats, namely:
  - Babylon .BGL files, complete with images and resources
  - StarDict .ifo/.dict./.idx/.syn dictionaries
  - Dictd .index/.dict(.dz) dictionary files
  - ABBYY Lingvo .dsl source files, together with abbreviations. The
    files can be optionally compressed with dictzip. Dictionary
    resources can be packed together into a .zip file.
  - ABBYY Lingvo .lsa/.dat audio archives. Those can be indexed
    separately, or be referred to from .dsl files.
* Support for Wikipedia, Wiktionary, or any other MediaWiki-based sites
  to perform lookups in.
* Ability to use arbitrary websites as dictionaries via templated Url
  patterns.
* Support for looking up and listening to pronunciations from forvo.com
* Hunspell-based morphology system, used for word stemming and spelling
  suggestions.
* Ability to index arbitrary directories with audio files for
  pronunciation lookups.
* Full Unicode case, diacritics, punctuation and whitespace folding.
  This means the ability to type in words without any accents, correct
  case, punctuation or spaces.
* Scan popup functionality. A small window pops up with the translation
  of a word chosen from another application.
* Support for global hotkeys. You can spawn the program window at any
  point, or directly translate a word from the clipboard.
* Tabbed browsing in a modern Qt 4 interface.

%prep
%setup -q
%autopatch -p1

%build
export PREFIX=%_prefix
%qmake_qt5 DISABLE_INTERNAL_PLAYER=1 CONFIG+=no_epwing_support %name.pro
%make_build

%install
%installqt5

# our find-lang.sh doesn't recognize .qm translation files
%find_lang --with-qt goldendict
echo "%_datadir/%name/locale/ie_001.qm" >> goldendict.lang
rm -rf %buildroot%_datadir/app-install

%files -f goldendict.lang
%_bindir/*
%attr(0644, root, root) %_datadir/applications/*.desktop
%_pixmapsdir/*
%dir %_datadir/%name
%dir %_datadir/%name/locale
%_datadir/%name/help
%_datadir/metainfo/*.xml

%changelog
