Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           google-gson
Version:        2.8.6
Release:        alt1_7jpp11
Summary:        Java lib for conversion of Java objects into JSON representation
License:        ASL 2.0
URL:            https://github.com/google/gson
Source0:        https://github.com/google/gson/archive/gson-parent-%{version}.tar.gz

# PR sent upstream: https://github.com/google/gson/pull/1770
Patch0: 0001-Update-to-latest-version-of-bnd-maven-plugin.patch

# Internal packages are naughtily used by other packages in Fedora
Patch1: 0002-Also-export-internal-packages-in-OSGi-metadata.patch

Patch2: 0003-Allow-building-on-Java-8.patch

# Remove dependency on unavailable templating-maven-plugin
# Reverts upstream commit https://github.com/google/gson/commit/d84e26d
Patch3: 0004-This-commit-added-a-dependency-on-templating-maven-p.patch

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
Source44: import.info

%description
Gson is a Java library that can be used to convert a Java object into its
JSON representation. It can also be used to convert a JSON string into an
equivalent Java object. Gson can work with arbitrary Java objects including
pre-existing objects that you do not have source-code of.

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n gson-gson-parent-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

# remove unnecessary dependency on parent POM
%pom_remove_parent

# presence of these files breaks builds with Java 8, see also Patch2: 0003-Allow-building-on-Java-8.patch
find -name "module-info.java" -print -delete

# Use felix maven-bundle-plugin only for OSGi metadata
%pom_remove_plugin :bnd-maven-plugin gson
%pom_xpath_inject "pom:plugin[pom:artifactId='maven-bundle-plugin']" "<configuration>
    <instructions>
      <_include>bnd.bnd</_include>
    </instructions>
  </configuration>
  <executions>
    <execution>
      <id>create-manifest</id>
      <phase>process-classes</phase>
      <goals><goal>manifest</goal></goals>
    </execution>
  </executions>" gson

%build
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE
%doc README.md CHANGELOG.md UserGuide.md

%files javadoc  -f .mfiles-javadoc
%doc --no-dereference LICENSE

%changelog
