%define _unpackaged_files_terminate_build 1

%define gpgme_sover 11
%define libgpgme libgpgme%gpgme_sover
%define gpgmepp_sover 6
%define libgpgmepp libgpgmepp%gpgmepp_sover
%define qgpgme_sover 15
%define libqgpgme libqgpgme%qgpgme_sover

%define min_gnupg_version 1.9.6
%define gpg_bin_path %_bindir/gpg2
%define gpgsm_bin_path %_bindir/gpgsm

%def_disable beta

%add_python3_req_skip _gpgme
%add_python_req_skip _gpgme

Name: gpgme
Version: 1.23.2
Release: alt1

Summary: GnuPG Made Easy is a library designed to make access to GnuPG easier for applications
License: LGPLv2.1+
Group: System/Libraries
Url: http://www.gnupg.org/related_software/gpgme/index.html

Conflicts: libgpgme-devel < 1.7
Requires: %gpg_bin_path

# ftp://ftp.gnupg.org/gcrypt/gpgme/gpgme-%version.tar.bz2
Source: gpgme-%version.tar

# Upstream patches
# --

# Suse
Patch2: gpgme-D545-python310.patch

# ALT
Patch3: gpgme-1.23.1-fix-easy_install.patch
Patch11: gpgme-1.4.3-alt-version-script.patch
Patch15: alt-revision.patch

%define gostversion 1.0.0
Patch16: gost-constants.patch

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires(pre): python-devel python3-devel
BuildRequires: /proc gcc-c++ gnupg2 libgpg-error-devel libpth-devel libstdc++-devel libassuan-devel >= 2.0
BuildRequires: texinfo
BuildRequires: qt5-base-devel swig
BuildRequires: glib2-devel

%package common
Summary: %name common package
Group: System/Configuration/Other
Conflicts: libgpgme < 1.7
%description common
%name common package

%package -n %libgpgme
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Requires: %gpg_bin_path
%description -n %libgpgme
%name library

%package -n %libgpgmepp
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libgpgmepp
%name library

%package -n %libqgpgme
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libqgpgme
%name library

%package -n lib%name
Summary: GnuPG Made Easy!
Group: System/Libraries
Requires: %libgpgme
Provides: libgpgme1 = %version-%release
Obsoletes: libgpgme1 < %version-%release

%package -n lib%name-devel
Summary: Include files for development with GPGME
Group: Development/C
Requires: libgpg-error-devel
Provides: libgpgme1-devel = %version-%release
Obsoletes: libgpgme1-devel < %version-%release

%package -n lib%name-devel-static
Summary: Static libraries for development with GPGME
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: libgpgme1-devel-static = %version-%release
Obsoletes: libgpgme1-devel-static < %version-%release

%package -n python3-module-gpg
Summary: Python GpgME pindings
Group: Development/Python
%description -n python3-module-gpg
Python GpgME pindings

%package -n python-module-gpg
Summary: Python GpgME pindings
Group: Development/Python
%description -n python-module-gpg
Python GpgME pindings

%description
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

%description -n lib%name
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

%description -n lib%name-devel
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

This package contains include files required for development of
GPGME-based applications.

%description -n lib%name-devel-static
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

This package contains static libraries required for development of
GPGME-based statically linked applications.

%prep
%setup

%patch2 -p1
%patch3 -p2
%patch11 -p1
%patch15 -p2
%patch16 -p1

%if_disabled beta
sed -i -e 's/@BETA@/no/' configure.ac
%else
sed -i -e 's/@BETA@/yes/' configure.ac
%endif
sed -i -e 's/@REVISION@/gost-%gostversion/' -e 's/@REVISION_DESC@/ALT/' configure.ac

%autoreconf

%build
mkdir -p tmp_bin
ln -sf %_bindir/gpg2 tmp_bin/gpg
export PATH=$PWD/tmp_bin:$PATH

%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
# --enable-maintainer-mode is required to generate the info file
# when building from CVS snapshot
%configure \
	--disable-silent-rules \
	%{?cvsdate: --enable-maintainer-mode } \
	%{subst_enable static} \
	--disable-fd-passing \
	--with-gpg=%gpg_bin_path \
	--with-gpgsm=%gpgsm_bin_path \
	#

%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std

# Keep only PKG-INFO and *.txt files in egg-info dirs.
find %buildroot%python3_sitelibdir/gpg-%version-py*egg-info \
     %buildroot%python_sitelibdir/gpg-%version-py*egg-info \
     -mindepth 1 -maxdepth 1 \
     ! -name  'PKG-INFO' -a ! -name '*.txt' \
     -delete

#check
#export PATH=$PWD/tmp_bin:$PATH
#%make_build -k check

%files
%_bindir/gpgme-tool
%_bindir/gpgme-json

%files common
%doc AUTHORS NEWS README THANKS

%files -n python3-module-gpg
%python3_sitelibdir/gpg-%version-py*egg-info
%dir %python3_sitelibdir/gpg
%python3_sitelibdir/gpg/*

%files -n python-module-gpg
%python_sitelibdir/gpg-%version-py*egg-info
%dir %python_sitelibdir/gpg
%python_sitelibdir/gpg/*

%files -n lib%name-devel
%_bindir/gpgme-config
%_includedir/*.h
%_includedir/gpgme++/
%_includedir/QGpgME/
%_includedir/qgpgme/
%_libdir/*.so
%_libdir/cmake/Gpgmepp/
%_libdir/cmake/QGpgme/
%_datadir/aclocal/*.m4
%_infodir/*.info*
%_pkgconfigdir/%name.pc
%_pkgconfigdir/%name-*.pc
%_datadir/common-lisp/source/%name

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n lib%name
%files -n %libgpgme
%_libdir/libgpgme.so.%gpgme_sover
%_libdir/libgpgme.so.%gpgme_sover.*
%files -n %libgpgmepp
%_libdir/libgpgmepp.so.%gpgmepp_sover
%_libdir/libgpgmepp.so.%gpgmepp_sover.*
%files -n %libqgpgme
%_libdir/libqgpgme.so.%qgpgme_sover
%_libdir/libqgpgme.so.%qgpgme_sover.*

%changelog
