Name: gptfdisk
Version: 1.0.9.1
Release: alt1

Summary: GPT partitioning and MBR repair software
License: GPLv2
Group: System/Configuration/Hardware

Url: https://www.rodsbooks.com/gdisk
Source: %name-%version.tar
# GIT: git://git.code.sf.net/p/gptfdisk/code

BuildRequires(pre): rpm-macros-make
BuildRequires: gcc-c++ libuuid-devel libpopt-devel libncursesw-devel

%description
Partitioning software for GPT disks and to repair MBR
disks. The gdisk and sgdisk utilities (in the gdisk
package) are GPT-enabled partitioning tools; the
fixparts utility (in the fixparts package) fixes some
problems with MBR disks that can be created by buggy
partitioning software.

%package -n gdisk
Group: System/Configuration/Hardware
Summary: An fdisk-like partitioning tool for GPT disks

%description -n gdisk
An fdisk-like partitioning tool for GPT disks. GPT
fdisk features a command-line interface, fairly direct
manipulation of partition table structures, recovery
tools to help you deal with corrupt partition tables,
and the ability to convert MBR disks to GPT format.

%package -n cgdisk
Group: System/Configuration/Hardware
Summary: A ncurses-based GUID partition table (GPT) manipulator

%description -n cgdisk
A ncurses-based GUID partition table (GPT) manipulator.

%package -n fixparts
Group: System/Configuration/Hardware
Summary: A tool for repairing certain types of damage to MBR disks

%description -n fixparts
A program that corrects errors that can creep into MBR-partitioned
disks. Removes stray GPT data, fixes mis-sized extended partitions,
and enables changing primary vs. logical partition status. Also
provides a few additional partition manipulation features.

%prep
%setup

%build
%make_ext

%check
./gdisk_test.sh

%install
mkdir -p %buildroot{%_sbindir,%_man8dir}
install -pm755 [^u]*disk fixparts %buildroot%_sbindir/
install -pm644 *.8 %buildroot%_man8dir/

%files -n gdisk
%doc NEWS COPYING README
%_sbindir/gdisk
%_sbindir/sgdisk
%_man8dir/gdisk*
%_man8dir/sgdisk*

%files -n cgdisk
%_sbindir/cgdisk
%_man8dir/cgdisk*

%files -n fixparts
%doc NEWS COPYING README
%_sbindir/fixparts
%_man8dir/fixparts*

%changelog
