%def_disable snapshot
%def_enable introspection
%def_enable vala
%def_enable docs

%define ver_major 15.1
%define api_ver 2.90
%define unicode_ver 14.0.0

Name: gucharmap
Version: %ver_major.4
Release: alt1

Summary: gucharmap is a featureful Unicode character map
Group: Text tools
License: GPL-3.0 and GFDL-1.3 and Unicode
Url: https://wiki.gnome.org/Gucharmap

%if_disabled snapshot
#Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Source: https://gitlab.gnome.org/GNOME/%name/-/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define meson_ver 0.62
%define glib_ver 2.32.0
%define gtk_ver 3.4.0
%define pcre_ver 10.21

Requires: lib%name = %EVR
Requires: dconf gnome-icon-theme

BuildRequires(pre): rpm-macros-meson rpm-build-gnome %{?_enable_introspection:rpm-build-gir}
BuildRequires: meson >= %meson_ver unicode-ucd >= %unicode_ver unzip
BuildRequires: gnome-common desktop-file-utils appdata-tools
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libpcre2-devel >= %pcre_ver
BuildRequires: yelp-tools gtk-doc
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libgtk+3-gir-devel}

%description
This package provides a featureful Unicode character map for GNOME.

%package -n lib%name
Summary: Shared library needed to run %name
Group: System/Libraries

%description -n lib%name
This package provides shared library for programs that show character maps
(including Gucharmap and a character map applet for the GNOME panel).

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains headers and libraries needed to compile
applications against lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the GNOME Unicode character map library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the 

%package -n lib%name-devel-doc
Summary: Development documentation for %name library
Group: Development/Documentation
Conflicts: lib%name < %EVR
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for GNOME Unicode
character map library.


%prep
%setup

%build
%meson \
    %{?_disable_introspection:-Dgir=false} \
    %{?_disable_vala:-Dvapi=false} \
    %{?_disable_docs:-Ddocs=false} \
    -Ducd_path=%_datadir/unicode/ucd
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/glib-2.0/schemas/org.gnome.Charmap.gschema.xml
%_datadir/metainfo/%name.metainfo.xml
%doc README* TODO COPYING.UNICODE

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.*}

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Gucharmap-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Gucharmap-%api_ver.gir
%endif

%if_enabled docs
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name-%api_ver/
%endif

%changelog
