
%define _unpackaged_files_terminate_build 1

Name: hydrogen
Version: 1.0.2
Release: alt1.1

Summary: Hydrogen Drum Machine
License: GPL
Group: Sound
URL: http://www.hydrogen-music.org

# https://github.com/hydrogen-music/hydrogen.git
Source0: %name-%version.tar

BuildRequires: ccmake ctest doxygen gcc-c++ graphviz ladspa_sdk libalsa-devel libarchive-devel libjack-devel liblo-devel liblrdf-devel
BuildRequires: libportaudio2-devel libportmidi librubberband-devel libsndfile-devel libtar-devel libpulseaudio-devel cppunit-devel
BuildRequires: qt5-base-devel qt5-tools-devel qt5-xmlpatterns-devel zlib-devel

BuildRequires: desktop-file-utils

%description
Hydrogen is a sample based drum machine with:
 Graphical user interface based on QT
 Sample based real-time audio engine
 Oss Audio driver
 Jack Audio driver
 Export to disk audio driver
 Alsa Midi input
 Ability to import/export xml-based song file
 64 ticks per pattern
 16 voices with volume, mute, solo, pan capabilities
 Import of samples in wav, au, aiff format

%prep
%setup

%build
%cmake -DWANT_RUBBERBAND=ON
%cmake_build

%install
%cmake_install

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Midi \
	%buildroot%_desktopdir/org.hydrogenmusic.Hydrogen.desktop

%files
%doc -P AUTHORS ChangeLog README.txt
%_bindir/*
%_datadir/%name/
%_libdir/*.so
%_desktopdir/*.desktop
%_datadir/appdata/*.xml
%_iconsdir/hicolor/scalable/apps/*.svg
%_man1dir/%name.1*

# TODO: put headers into separate subpackage
%exclude /usr/include/%name

%changelog
