%def_disable snapshot
%define real_ver_major 69
%define real_ver_minor 1
%define real_ver %{real_ver_major}.%{real_ver_minor}

%def_without doc

#%%ifarch aarch64 ppc64le
#%%def_disable check
#%%endif

Name: icu
Version: %(echo %real_ver_major | sed -e 's|\(.\)|\1.|').%real_ver_minor
Release: alt2
Epoch: 1

Summary: International Components for Unicode
Group: System/Libraries
License: ICU and BSD-3-Clause and Unicode-TOU and naist-2003
Url: http://www.icu-project.org/

%if_disabled snapshot
Source: https://github.com/unicode-org/%name/releases/download/release-%{real_ver_major}-%{real_ver_minor}/icu4c-%{real_ver_major}_%{real_ver_minor}-src.tgz
%else
Vcs: https://github.com/unicode-org/icu.git
Source: icu-%version.tar
%endif
Patch: icu-6.3.1-alt-e2k.patch
# https://github.com/unicode-org/icu/pull/1715
# https://github.com/unicode-org/icu/commit/29f1188d191a7a75ac7ffa4bfa390f625da39c53.patch
Patch1: icu-69.1-Fix_undefined_behaviour_in_ComplexUnitsConverter.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ libstdc++-devel python3-base
%{?_with_doc:BuildRequires: doxygen}

%define libicu libicu%real_ver_major

%description
ICU is a C++ and C library that provides robust and full-featured Unicode
support

%package utils
Summary: International Components for Unicode (utilities)
Group: Text tools
Requires: %libicu = %EVR
Provides: icu = %version
Obsoletes: icu < %version

%description utils
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the utilites for compiling and developing
programs with ICU

%package -n %libicu
Summary: International Components for Unicode (libraries)
Group: System/Libraries
Provides: libicu = %EVR
Obsoletes: libicu < %EVR

%description -n %libicu
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the runtime libraries for ICU

%package -n libicu-devel
Summary: International Components for Unicode (development files)
Group: Development/C++
Requires: %libicu = %EVR
Requires: icu-utils = %EVR

%description -n libicu-devel
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the development files for ICU

%package samples
Summary: Sample programs for ICU
Group: Development/Other
Requires: libicu-devel = %EVR
BuildArch: noarch

%description samples
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains sample code for ICU

%prep
%setup -c
%setup -DT -n %name-%version/icu
%ifarch %e2k
%patch -p2
%add_optflags -finput-charset=utf8
%endif
%patch1 -p2

sed -ri '/^LDFLAGSICUDT=/ s,-nodefaultlibs -nostdlib,,' source/config/mh-linux

%build
export PYTHON=%__python3
%add_optflags %(getconf LFS_CFLAGS)
cd source
%autoreconf
%configure \
	--disable-samples \
	--disable-static \
	--with-data-packaging=library
%make_build

%install
cd source
%makeinstall_std
cp -a samples %buildroot%_datadir/icu

%check
cd source
%make check

%files utils
%_bindir/*
%exclude %_bindir/icu-config
%_sbindir/*
%exclude %_man1dir/icu-config.1*
%_man1dir/*
%_man8dir/*

%files -n %libicu
%_libdir/*.so.*
%doc LICENSE readme.html

%files -n libicu-devel
%_includedir/*
%_bindir/icu-config
%_libdir/*.so
%_libdir/icu
%_pkgconfigdir/*.pc
%dir %_datadir/icu
%_datadir/icu/%real_ver
%_man1dir/icu-config.1*
%doc *.html *.css

%files samples
%_datadir/icu/samples

%changelog
