Name: iftop
Version: 0.17
Release: alt5

Summary: Display bandwidth usage on an interface
License: GPL
Group: Monitoring

Url: http://www.ex-parrot.com/~pdw/iftop/
Packager: Michael Shigorin <mike@altlinux.org>

# %url/download/iftop-%version.tar.gz
Source: iftop-%version.tar
Patch: iftop-%version-%release.patch

Summary(ru_RU.UTF-8): Отображает использование полосы пропускания сети

Requires(pre): shadow-utils
Requires: /var/resolv

# Automatically added by buildreq on Wed Jan 20 2010
BuildRequires: libncurses-devel libpcap-devel

%description
iftop does for network usage what top(1) does for CPU usage.
It listens to network traffic on a named interface and displays
a table of current bandwidth usage by pairs of hosts.  Handy for
answering the question "why is our internet link so slow?".

%description -l ru_RU.UTF-8
iftop - аналог top(1) по части использования сети: слушает
трафик на указанном интерфейсе и отображает таблицу текущего
использования по парам хостов.  Удобно для ответа на вопрос
"почему наш канал так тормозит?".

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing -DNO_SYSTEM
%autoreconf
%configure --with-user=_iftop --with-chroot=/var/resolv
%make_build

%install
%makeinstall
mkdir -p %buildroot%_bindir
chmod 700 %buildroot%_sbindir/iftop
mv %buildroot%_sbindir/iftop %buildroot%_bindir/
ln -sr %buildroot{%_bindir,%_sbindir}/iftop
install -pDm755 iftop.control %buildroot%_controldir/iftop

%pre
%_sbindir/groupadd -r -f netadmin
%pre_control iftop

%post
%_sbindir/groupadd -r -f _iftop
%_sbindir/useradd -r -g _iftop -d /dev/null -s /dev/null -n _iftop >/dev/null 2>&1 ||:
%post_control -s netadmin iftop

%files
%_bindir/*
%_sbindir/*
%_controldir/iftop
%_man8dir/*
%doc ChangeLog README TODO

%changelog
