Epoch: 0
Group: Development/Other
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           javassist
Version:        3.27.0
Release:        alt1_2jpp11
Summary:        Java Programming Assistant for Java bytecode manipulation
License:        MPLv1.1 or LGPLv2+ or ASL 2.0

%global upstream_version rel_%(sed s/\\\\./_/g <<<"%{version}")_ga

URL:            https://www.javassist.org/
Source0:        https://github.com/jboss-%{name}/%{name}/archive/%{upstream_version}/%{name}-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.hamcrest:hamcrest-all)
Source44: import.info

%description
Javassist enables Java programs to define a new class at runtime and to
modify a class file when the JVM loads it. Unlike other similar
bytecode editors, Javassist provides two levels of API: source level
and bytecode level. If the users use the source-level API, they can
edit a class file without knowledge of the specifications of the Java
bytecode. The whole API is designed with only the vocabulary of the
Java language. You can even specify inserted bytecode in the form of
source text; Javassist compiles it on the fly. On the other hand, the
bytecode-level API allows the users to directly edit a class file as
other editors.


%package javadoc
Group: Development/Java
Summary:        Javadocs for javassist
BuildArch: noarch

%description javadoc
javassist development documentation.


%prep
%setup -q -n %{name}-%{upstream_version}

# remove unnecessary maven plugins
%pom_remove_plugin :maven-source-plugin

# disable profiles that only add com.sun:tools dependency
%pom_xpath_remove "pom:profiles"

# add compatibility alias for old maven artifact coordinates
%mvn_alias : %{name}:%{name}

# add compatibility symlink for old classpath
%mvn_file : %{name}


%build
%mvn_build -f

# remove bundled jar and class files *after* they were used for running tests
rm javassist.jar src/test/resources/*.jar
find src/test -name "*.class" -print -delete


%install
%mvn_install


%files -f .mfiles
%doc --no-dereference License.html
%doc Readme.html

%files javadoc -f .mfiles-javadoc
%doc --no-dereference License.html


%changelog
