Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: gcc-c++ texinfo unzip
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global cluster jnr
%global sover 1.2

Name:           jffi
Version:        1.2.23
Release:        alt1_5jpp11
Summary:        Java Foreign Function Interface

License:        LGPLv3+ or ASL 2.0
URL:            http://github.com/jnr/jffi
Source0:        https://github.com/%{cluster}/%{name}/archive/%{name}-%{version}.tar.gz
Source3:        p2.inf

# Fix references to junit/hamcrest to match what is generated by `build-jar-repository`
Patch0:         0001-Fix-dependencies-on-junit-hamcrest.patch

# Fix compilation flags and binary stripping
Patch1:         0002-Fix-compilation-flags.patch

# Allow building on Java 11
Patch2:         0003-Fix-native-header-generation.patch

# Fix java version detection of Java 9+
Patch3:         0004-Fix-java-version-detection.patch

BuildRequires:  gcc
BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-assembly-plugin)
BuildRequires:  libffi-devel
BuildRequires:  ant
BuildRequires:  ant-junit
Source44: import.info

%description
An optimized Java interface to libffi.

%package native
Group: System/Libraries
Summary:        %{name} JAR with native bits

%description native
This package contains %{name} JAR with native bits.

%package javadoc
Group: System/Libraries
Summary:        Javadoc for %{name}
BuildArch:      noarch

%description javadoc
This package contains the API documentation for %{name}.


%prep
%setup -q -n %{name}-%{name}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

# Remove pointless parent pom
%pom_remove_parent

# Port to maven-antrun-plugin 3.0.0
sed -i s/tasks/target/ pom.xml

# Allow building on Java 11
for f in src/main/java/com/kenai/jffi/{Foreign,ObjectBuffer}.java version.xml; do
  # Add the import for @Native
  sed -i '/package .*;/ a import java.lang.annotation.Native;' $f
  # Set @Native for fields
  sed -i '/\(static final\|final static\) int [A-Z]/ i @Native' $f
done

# Don't attempt to override arch configuration from RPM flags
sed -i -e '/i586/d' jni/GNUmakefile

# remove uneccessary directories
rm -r archive/* jni/libffi/ lib/junit*

# Remove any pre-build bytecode
find ./ -name '*.jar' -exec rm -f '{}' \; 
find ./ -name '*.class' -exec rm -f '{}' \; 

# Test dependencies for ant tests
build-jar-repository -s -p lib/ junit hamcrest/core

# A couple of tests fail on armv7 for some reason
sed -i -e 's/haltonfailure="true"/haltonfailure="no"/' build.xml

# Ensure debug symbols in the native java
sed -i -e 's/<javac/<javac debug="true"/' build.xml

%mvn_package 'com.github.jnr:jffi::native:' native
%mvn_file ':{*}' %{name}/@1 @1

%build
# ant will produce JAR with native bits
ant jar build-native -Duse.system.libffi=1

# maven will look for JAR with native bits in archive/
cp -p dist/jffi-*-Linux.jar archive/

%mvn_build

# Ensure jar with correct manifest is the one that is installed
cp target/jffi-%{version}-complete.jar target/jffi-%{version}.jar

%install
%mvn_install

mkdir -p META-INF/
cp %{SOURCE3} META-INF/
jar uf %{buildroot}%{_jnidir}/%{name}/%{name}.jar META-INF/p2.inf

# install *.so
install -dm 755 %{buildroot}%{_libdir}/%{name}
unzip dist/jffi-*-Linux.jar
mv jni/*-Linux %{buildroot}%{_libdir}/%{name}/
# create version-less symlink for .so file
pushd %{buildroot}%{_libdir}/%{name}/*
chmod +x lib%{name}-%{sover}.so
ln -s lib%{name}-%{sover}.so lib%{name}.so
popd

%check
# don't fail on unused parameters... (TODO: send patch upstream)
sed -i 's|-Werror||' libtest/GNUmakefile
ant -Duse.system.libffi=1 -Drun.jvm.model=-Xmx128m test

%files -f .mfiles
%doc --no-dereference COPYING.GPL COPYING.LESSER LICENSE

%files native -f .mfiles-native
%{_libdir}/%{name}
%doc --no-dereference COPYING.GPL COPYING.LESSER LICENSE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference COPYING.GPL COPYING.LESSER LICENSE

%changelog
