%define _unpackaged_files_terminate_build 1

%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

Name: kchmviewer
Version: 8.0
Release: alt2
Summary: A CHM (Winhelp) and EPUB viewer
License: %gpl3plus
Group: Office
Url: http://kchmviewer.net

# https://github.com/gyunaev/kchmviewer.git
Source: %name-%version.tar

Patch1: %name-%version-upstream.patch
Patch2: kchmviewer-8.0-remove-updates-check.patch
Patch3: kchmviewer-8.0-remove-whats-this-function.patch
Patch4: kchmviewer-8.0-remove-debug-output.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-macros-qt5
BuildRequires: gcc-c++ libchm-devel libzip-devel qt5-base-devel
BuildRequires: libXxf86misc-devel
%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%else
BuildRequires: qt5-webkit-devel
%endif

Obsoletes: kchmviewer4 < %EVR
Obsoletes: kchmviewer-nokde < %EVR

%description
Kchmviewer is a CHM (aka MS HTML help) and EPUB viewer written in C++.
The main advantage of KchmViewer is extended support for non-English
languages. Unlike others, KchmViewer in most cases correctly detects chm
file encoding, correctly shows tables of context of Russian, Korean,
Chinese and Japanese help files. It also correctly searches text in
non-English help files, including Korean, Chinese and Japanese.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%if_disabled qtwebengine
sed -i -E '/^[[:space:]]+greaterThan\(QT_MINOR_VERSION/s|QT_MINOR_VERSION.*$|QT_MINOR_VERSION, 666) {|' src/src.pro
%endif

%build
%add_optflags -I%_includedir/libzip
%qmake_qt5
%make_build

%install
%installqt5
install -pD -m755 bin/kchmviewer %buildroot%_bindir/%name
install -pD -m644 packages/kchmviewer.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png
install -pD -m644 packages/kchmviewer.desktop %buildroot%_desktopdir/%name.desktop

%files
%_bindir/%name
%_iconsdir/hicolor/*/apps/%name.png
%_desktopdir/%name.desktop
%doc ChangeLog DBUS-bindings FAQ README
%doc COPYING

%changelog
