%define module_name    lin-tape
%define module_version 3.0.56
%define module_release alt1

%define flavour	std-def
%define karch %ix86 x86_64
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-std-def

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/%module_name

Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
Epoch: 0

Summary: Linux Kernel drivers for IBM Tape SCSI Devices
License: GPL-2.0
Group: System/Kernel and hardware
Url: http://www.charmexdocs.com/int/software/SBS0962_LINUX.zip

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

Patch0: use-module-dir.patch
Patch1: clean-ifdefs.patch
Patch2: kernel-5.8.patch
Patch3: kernel-5.10.patch
Patch4: kernel-5.12.patch
Patch5: build-modules.patch

ExclusiveOS: Linux
BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Requires(pre,postun): kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
The IBM Tape Device Driver, lin_tape, provides attachment and advance
functionality for use with IBM and other vendor tape devices to Linux
compatible platforms.

%prep
rm -rf kernel-source-%module_name-%module_version
tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2
%setup -D -T -n kernel-source-%module_name-%module_version
%autopatch -p1

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make KERNEL_SRC=%_usrsrc/linux-%kversion-%flavour-%krelease \
    KERNELRELEASE=%kversion-%flavour-%krelease \
    KERNEL=%kversion-%flavour-%krelease \
    PROC=%_arch \
    SFMP=0 \
    modules

%install
mkdir -p %buildroot/%module_dir
cp -a *.ko %buildroot/%module_dir

%files
%module_dir

%changelog
