# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%define vermajor 1
%define verminor 6.3
%define version %vermajor.%verminor

Name: keyutils
Version: %version
Release: alt1

Summary: Linux Key Management Utilities
License: GPL-2.0-only and LGPL-2.1
Group: System/Base
Url: http://people.redhat.com/~dhowells/keyutils/
Vcs: https://git.kernel.org/pub/scm/linux/kernel/git/dhowells/keyutils.git

Source0: %name-%version.tar

BuildRequires: gcc-c++

%description
Utilities to control the kernel key management facility and to provide
a mechanism by which the kernel call back to userspace to get a key
instantiated.

%package -n lib%name
Summary: Key utilities library
Group: System/Libraries

%package -n lib%name-devel
Summary: Development package for building linux key management utilities
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name
This package provides a wrapper library for the key management facility system
calls.

%description -n lib%name-devel
This package provides headers and libraries for building key utilities.

%prep
%setup

%build
%make_build \
    NO_ARLIB=1 \
    LIBDIR=/%_lib \
    USRLIBDIR=%_libdir \
    RELEASE=.%release \
    NO_GLIBC_KEYERR=1 \
    CFLAGS="-Wall $RPM_OPT_FLAGS -Werror"

%install
%make_build \
    NO_ARLIB=1 \
    DESTDIR=%buildroot \
    LIBDIR=/%_lib \
    USRLIBDIR=%_libdir \
    PKGCONFIG_DIR=../%_pkgconfigdir \
    install
ln -snf ../../%_lib/lib%name.so.1 %buildroot%_libdir/lib%name.so

%files
%doc README LICENCE.GPL
%config(noreplace) %_sysconfdir/request-key.conf
%dir %_sysconfdir/request-key.d
/sbin/*
/bin/*
%_datadir/%name
%_man1dir/*
%_man5dir/*
%_man7dir/*
%_man8dir/*

%files -n lib%name
/%_lib/lib%name.so.*

%files -n lib%name-devel
%doc LICENCE.LGPL
%_libdir/lib%name.so
%_includedir/*
%_man3dir/*
%_pkgconfigdir/*.pc

%changelog
