%define rname kconfig
%def_enable notify
%def_disable python
%if_enabled python
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

Name: kf5-%rname
Version: 5.116.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 advanced configuration system
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar
Patch2: alt-kconfig-notify-via-dbus.patch
Patch3: alt-small-not-authorize-donate.patch

# Automatically added by buildreq on Wed Dec 24 2014 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libcloog-isl4 libqt5-core libqt5-gui libqt5-test libqt5-widgets libqt5-xml libstdc++-devel python-base qt5-base-devel qt5-tools ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules gcc-c++ python-module-google qt5-tools-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
%if_enabled python
BuildRequires(pre): python3-module-sip-devel
BuildRequires: python3-module-PyQt5-devel
%endif
BuildRequires: gcc-c++ extra-cmake-modules qt5-base-devel qt5-declarative-devel qt5-tools-devel

%description
KConfig provides an advanced configuration system.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5configgui
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5configgui
KF5 library

%package -n libkf5configcore
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5configcore
KF5 library

%package -n libkf5configqml
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5configqml
KF5 library

%if_enabled python
%package -n python3-module-%rname
Summary: Python3 bindings for KConfig
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-pykf5
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KConfig

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%prep
%setup -n %rname-%version
%if_enabled notify
%patch2 -p2
%endif
%patch3 -p1

%build
NPROCS=1 %K5build

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name
rm -rf %buildroot%_libdir/*/*/*/__*


%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories5/*.*categories

%files
%_bindir/kreadconfig5
%_K5bin/kreadconfig5
%_bindir/kwriteconfig5
%_K5bin/kwriteconfig5
%if_enabled notify
%_K5bin/kconf_watcher
%_K5bin/kconf_apply
%endif

%files devel
%_K5exec/kconfig_compiler_kf5
#%_K5inc/kconfig_version.h
%_K5inc/KConfig/kconfig_version.h
%_K5inc/KConfigCore/
%_K5inc/KConfigGui/
%_K5inc/KConfigQml/
%_K5link/lib*.so
%_K5lib/cmake/KF5Config
%_K5archdata/mkspecs/modules/qt_KConfigCore.pri
%_K5archdata/mkspecs/modules/qt_KConfigGui.pri

%files -n libkf5configcore
%_K5lib/libKF5ConfigCore.so.*
%_K5exec/kconf_update
%files -n libkf5configgui
%_K5lib/libKF5ConfigGui.so.*
%files -n libkf5configqml
%_K5lib/libKF5ConfigQml.so.*

%if_enabled python
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KConfigGui/
%_datadir/sip3/PyKF5/KConfigCore/
%endif

%changelog
