%define rname kitemmodels
%def_disable python
%if_enabled python
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

Name: kf5-%rname
Version: 5.116.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: Set of item models extending the Qt model-view framework
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar

# Automatically added by buildreq on Wed Dec 24 2014 (-bi)
# optimized out: cmake cmake-modules elfutils libcloog-isl4 libqt5-core libstdc++-devel python-base ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules gcc-c++ python-module-google qt5-base-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
%if_enabled python
BuildRequires(pre): python3-module-sip-devel
BuildRequires: python3-module-PyQt5-devel
%endif
BuildRequires: extra-cmake-modules qt5-declarative-devel qt5-tools-devel

%description
KItemModels provides a set of item models extending the Qt model-view framework.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: kf5-filesystem
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%if_enabled python
%package -n python3-module-%rname
Summary: Python3 bindings for KItemViews
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-pykf5
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KItemViews

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%package -n libkf5itemmodels
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5itemmodels
KF5 library


%prep
%setup -n %rname-%version

%build
%K5build

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name
rm -rf %buildroot%_libdir/*/*/*/__*


%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories5/*.*categories

%files devel
%_K5link/lib*.so
#%_K5inc/kitemmodels_version.h
%_K5inc/KItemModels/
%_K5lib/cmake/KF5ItemModels
%_K5archdata/mkspecs/modules/qt_KItemModels.pri

%if_enabled python
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KItemModels/
%endif

%files -n libkf5itemmodels
%_K5lib/libKF5ItemModels.so.*
%_K5qml/org/kde/kitemmodels/

%changelog
