%define _unpackaged_files_terminate_build 1
%def_with check

Name: kitty
Version: 0.32.2
Release: alt2

Summary: Cross-platform, fast, feature-rich, GPU based terminal
License: GPL-3.0
Group: Terminals
VCS: https://github.com/kovidgoyal/kitty
Url: https://sw.kovidgoyal.net/kitty/

Requires: %name-kitten = %EVR
Requires: %name-terminfo = %EVR
Requires: %name-shell-integration = %EVR

Source: %name-%version.tar
Patch0: %name-%version-alt.patch
Patch1: 0001-setup.py-fixed-check-for-control-flow-protection.patch

# 0.27.0: unmet /usr/pkg/bin/tic
%add_findreq_skiplist %_libexecdir/kitty/shell-integration/ssh/bootstrap-utils.sh

# play sound
Requires: libcanberra
# panel kitten
Requires: libstartup-notification
# icat kitten
Requires: ImageMagick-tools

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-golang

BuildRequires: libXi-devel
BuildRequires: libXrandr-devel
BuildRequires: libXcursor-devel
BuildRequires: libXinerama-devel
BuildRequires: libxkbcommon-x11-devel

BuildRequires: wayland-protocols
BuildRequires: libwayland-client-devel
BuildRequires: libwayland-cursor-devel

BuildRequires: libGL-devel
BuildRequires: libpng-devel
BuildRequires: libssl-devel
BuildRequires: libdbus-devel
BuildRequires: liblcms2-devel
BuildRequires: libxxhash-devel
BuildRequires: fontconfig-devel
BuildRequires: libharfbuzz-devel

BuildRequires: python3-dev
BuildRequires: python3-module-sphinx-copybutton
BuildRequires: python3-module-sphinx-inline-tabs
BuildRequires: python3-module-sphinxext-opengraph
BuildRequires: python3-module-sphinx-sphinx-build-symlink

# tic for xterm-kitty terminfo
BuildRequires: ncurses

# + install -Dm644 /dev/stdin .../usr/share/bash-completion/completions/kitty
BuildRequires: /proc

%if_with check
BuildRequires: zsh
BuildRequires: bash
BuildRequires: fish
BuildRequires: /dev/pts
BuildRequires: fonts-ttf-gnu-freefont-mono
%endif

%add_python3_path %_libexecdir/kitty

%description
- Offloads rendering to the GPU for lower system load and buttery
  smooth scrolling. Uses threaded rendering to minimize input latency.

- Supports all modern terminal features: graphics (images), unicode,
  true-color, OpenType ligatures, mouse protocol, hyperlinks, focus
  tracking, bracketed paste and several new terminal protocol
  extensions.

- Supports tiling multiple terminal windows side by side in different
  layouts without needing to use an extra program like tmux

- Can be controlled from scripts or the shell prompt, even over SSH.

- Has a framework for Kittens, small terminal programs that can be
  used to extend kitty's functionality. For example, they are used for
  Unicode input, Hints and Side-by-side diff.

- Supports startup sessions which allow you to specify the window/tab
  layout, working directories and programs to run on startup.

- Cross-platform: kitty works on Linux and macOS, but because it uses
  only OpenGL for rendering, it should be trivial to port to other
  Unix-like platforms.

- Allows you to open the scrollback buffer in a separate window using
  arbitrary programs of your choice. This is useful for browsing the
  history comfortably in a pager or editor.

- Has multiple copy/paste buffers, like vim.


%package terminfo
Summary: The terminfo file for kitty
Group: System/Configuration/Other
BuildArch: noarch

%description terminfo
%summary.

%package shell-integration
Summary: Shell-integration files for kitty
Group: System/Configuration/Other
BuildArch: noarch

%description shell-integration
%summary.

%package kitten
Summary: Standalone kitten executable
Group: System/Configuration/Other

%description kitten
Statically compiled, standalone executable, kitten (written in Go) that
can be used on all UNIX-like servers for remote control (kitten @), viewing
images (kitten icat), manipulating the clipboard (kitten clipboard), etc.

%prep
%setup
%patch0 -p1
%patch1 -p1

# Changing shebangs to python3
find -type f -name "*.py" -exec sed -e 's|/usr/bin/env python3|%__python3|g'  \
                                    -e 's|/usr/bin/env python|%__python3|g'   \
                                    -i "{}" \;

# Our gcc enables "_FORTIFY_SOURCE=3" by default, remove defenition
# form setup.py to avoid error "_FORTIFY_SOURCE" redefined
sed -i -e "s/-D_FORTIFY_SOURCE=2//" setup.py

# Disable strip for kitten binary
sed -i -e "/ld_flags.append('-s')/d" -e "s/ld_flags.append('-w')/pass/" setup.py

# Fix arm detection
sed -i -e "/is_arm/ s/'aarch64'/'aarch64', 'armv8l'/" setup.py

# Disable fcf-protection on unsupported architectures
%ifarch %ix86 ppc64le
sed -i -e "s/-fcf-protection=full//" setup.py
%endif

# 0.32.2: Disable optimizations for kittens/transfer/algorithm.c:init_rsync()
# because it segfaults due to a bug in gcc10
sed -i -e '/^init_rsync(/ i__attribute__((optimize("O0")))' \
    kittens/transfer/algorithm.c

%build
%add_optflags -Wno-switch
export CFLAGS="${CFLAGS:-%optflags}"
export CGO_ENABLED=0
python3 setup.py linux-package \
    --verbose \
    --update-check-interval=0 \
    %nil

%install
mkdir -pv %buildroot
cp -r ./linux-package %buildroot%_prefix

%buildroot%_bindir/kitten __complete__ setup bash | \
    install -Dm644 /dev/stdin %buildroot%_datadir/bash-completion/completions/kitty

%buildroot%_bindir/kitten __complete__ setup zsh | \
    install -Dm644 /dev/stdin  %buildroot%_datadir/zsh/site-functions/_kitty

%buildroot%_bindir/kitten __complete__ setup fish | \
    install -Dm644 /dev/stdin %buildroot%_datadir/fish/vendor_completions.d/kitty.fish

%buildroot%_bindir/kitty \
    +runpy 'from kitty.config import *; print(commented_out_default_config())' \
    | install -Dm644 /dev/stdin %buildroot%_datadir/kitty/kitty.conf.default


%check
%ifarch ppc64le
# test_elliptic_curve_data_exchange fails on ppc64le due to 64k memlock limit in the
# chroot environmet which is not enough for 64k pagesize system
rm kitty_tests/crypto.py

# test_transfer_receive and test_transfer_send fail on ppc64le:
# "Error: inappropriate ioctl for device"
rm kitty_tests/file_transmission.py
%endif

PYTHONPATH="$PWD" linux-package/bin/kitty +launch ./test.py


%files
%_bindir/kitty
%_libexecdir/kitty/
%_datadir/kitty/
%exclude %_libexecdir/kitty/shell-integration
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*
%_man1dir/*
%_man5dir/*
%_datadir/bash-completion/completions/kitty
%_datadir/zsh/site-functions/_kitty
%_datadir/fish/vendor_completions.d/kitty.fish

%files terminfo
%_datadir/terminfo/*/*

%files shell-integration
%_libexecdir/kitty/shell-integration

%files kitten
%_bindir/kitten

%changelog
