Name:		kmod
Version:	30
Release:	alt1
Summary:	Linux kernel module management utilities

Group:		System/Kernel and hardware
License:	GPL-2.0-or-later AND LGPL-2.1-or-later
URL:		http://modules.wiki.kernel.org/
ExclusiveOS:	Linux
Requires:	lib%name = %version-%release

Source0:	%name-%version.tar

Patch0001: 0001-testsuite-repair-read-of-uninitialized-memory.patch
Patch0002: 0002-man-Fix-path.patch

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

BuildRequires: bash-completion
BuildRequires: docbook-dtds
BuildRequires: docbook-style-xsl
BuildRequires: glibc-devel-static
BuildRequires: liblzma-devel
BuildRequires: libssl-devel
BuildRequires: libzstd-devel
BuildRequires: xsltproc
BuildRequires: zlib-devel

Provides:	module-init-tools = 3.17-alt1
Obsoletes:	module-init-tools
Conflicts:	module-init-tools-compat

%description
The kmod package provides various programs needed for automatic
loading and unloading of modules under 2.6, 3.x, and later kernels, as well
as other module management programs. Device drivers and filesystems are two
examples of loaded and unloaded modules.

%package -n lib%name
Summary:	Libraries to handle kernel module loading and unloading
License:	LGPL-2.1-or-later
Group:		System/Kernel and hardware
Provides:	%name-libs = %version-%release

%description -n lib%name
The kmod-libs package provides runtime libraries for any application that
wishes to load or unload Linux kernel modules from the running system.

%package -n lib%name-devel
Summary:	Header files for kmod development
Group:		Development/C
License:	LGPL-2.1-or-later
Requires:	lib%name = %version-%release
Provides:	%name-devel = %version-%release

%description -n lib%name-devel
The libkmod-devel package provides header files used for development of
applications that wish to load or unload Linux kernel modules.

%package -n bash-completion-%name
Summary:        Bash completion routines for the kmod utilities
License:        GPL-2.0-or-later AND LGPL-2.1-or-later
Group:          Shells
BuildArch:      noarch
Requires:       %name
Requires:       bash-completion

%description -n bash-completion-%name
Contains bash completion support for kmod utilities.

%prep
%setup -q
%autopatch -p1

%build
touch libkmod/docs/gtk-doc.make
%autoreconf

%configure \
	--prefix=/ \
	--disable-static \
	--disable-test-modules \
	--bindir=/bin \
	--with-rootlibdir=/%_lib \
	--with-openssl \
	--with-zlib \
	--with-xz \
	--with-zstd \
	#
%make_build

%install
%make_install DESTDIR=%buildroot install
rm -rf %buildroot/%_libdir/*.la

# New configuration files we ship (if any) should go into /lib/modprobe.d
# in order to allow the local sysadmin to customize /etc/modprobe.d
mkdir -p %buildroot/{%_sysconfdir,/lib}/modprobe.d
mkdir -p %buildroot/{%_sysconfdir,/lib}/depmod.d

# Add blacklists from module-init-tools
find rpm/modprobe.d -maxdepth 1 -type f -name '*.conf' -print0 |
	xargs -r0 install -m644 -p -t %buildroot/lib/modprobe.d/ --

%ifarch %ix86 x86_64
install -m644 -p rpm/modprobe.d/arch/i386.conf %buildroot/lib/modprobe.d/arch.conf
%endif

# Make compatibility symlinks
mkdir -p %buildroot/sbin
for n in modprobe modinfo insmod rmmod depmod lsmod; do
	t=$(relative /bin/kmod /sbin/$n)
	ln -s "$t" "%buildroot/sbin/$n"
done

# lsmod was in /bin before
ln -s kmod %buildroot/bin/lsmod

%check
make check V=1

%files
%dir %_sysconfdir/depmod.d
%dir %_sysconfdir/modprobe.d
%dir /lib/depmod.d
%dir /lib/modprobe.d
/lib/modprobe.d/*.conf
/bin/kmod
/bin/lsmod
/sbin/depmod
/sbin/insmod
/sbin/lsmod
/sbin/modinfo
/sbin/modprobe
/sbin/rmmod
%_man5dir/*
%_man8dir/*
%doc NEWS README.md COPYING

%files -n lib%name
/%_lib/libkmod.so*

%files -n lib%name-devel
%_includedir/libkmod.h
%_libdir/pkgconfig/libkmod.pc
%_libdir/libkmod.so

%files -n bash-completion-%name
%_datadir/bash-completion/completions/*

%changelog
