
%def_without bootstrap
%def_with doc
%def_with ldap
%def_with selinux
%def_with verto
%def_with lmdb
%def_enable check

Name: krb5
Version: 1.19.4
Release: alt4

%if_without bootstrap
%if_with doc
%define _unpackaged_files_terminate_build 1
%endif
%endif

%define _docdir %_defaultdocdir/%name-%version

Summary: The Kerberos network authentication system
License: MIT
Group: System/Libraries
Url: http://web.mit.edu/kerberos/www/

Source0: %name-%version.tar
Source2: %name-alt.tar

# Carry this locally until it's available in a packaged form.
Source100: noport.c

# fedora patches:
Patch23: krb5-1.3.1-fedora-dns.patch
Patch39: krb5-1.12-fedora-api.patch
Patch60: krb5-1.18-fedora-pam.patch
Patch63: krb5-1.18-fedora-selinux-label.patch
Patch86: krb5-1.9-fedora-debuginfo.patch
Patch129: krb5-1.11-fedora-run_user_0.patch
# redhat
# https://bugzilla.redhat.com/show_bug.cgi?id=2176406
Patch156: downstream-Support-PAC-full-checksum-w-o-ticket-chec.patch

# alt patches:
Patch200: krb5-1.18-alt-default_keytab_group.patch
Patch201: krb5-1.19.1-alt-fix-zero-backlog-listen.patch

# backports
Patch301: krb5-1.19-fix-kadmin5-use-after-free.patch
Patch302: krb5-1.19.4-Use-14-instead-of-9-for-unkeyed-SHA-1-checksum.patch
Patch303: krb5-1.19.4-Fix-verification-of-RODC-issued-PAC-KDC-signature.patch
Patch304: krb5-1.19.4-Add-PAC-ticket-signature-APIs.patch
Patch305: krb5-1.19.4-Factor-out-PAC-checksum-verification.patch
Patch306: krb5-1.19.4-Add-PAC-full-checksums.patch
Patch307: krb5-1.19-upstream-fix-vulnerabilities-in-GSS-message-token-handling.patch

BuildRequires: /dev/pts /proc
BuildRequires: flex libcom_err-devel libkeyutils-devel
BuildRequires: libncurses-devel libss-devel libssl-devel libtinfo-devel
BuildRequires: libpam-devel

%{?_with_ldap:BuildRequires: libldap-devel libsasl2-devel}
%{?_with_verto:BuildRequires: libverto-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_lmdb:BuildRequires: liblmdb-devel}

%if_with doc
BuildRequires: python3-module-sphinx
BuildRequires: texlive-latex-base texlive-base-bin texlive-latex-recommended latexmk
%endif

%ifarch %{ix86} x86_64
%{?!_with_bootstrap:BuildRequires: yasm}
%endif

%if_enabled check
# for tests
BuildRequires: libverto-libev python-modules gcc-c++
# dejagnu tests disabled
# BuildRequires: dejagnu tcl-devel
%endif

%description
Kerberos V5 is a trusted-third-party network authentication system,
which can improve your network's security by eliminating the insecure
practice of cleartext passwords.

# {{{ subpackages

%package -n lib%name
Summary: The shared libraries used by Kerberos 5
Group: System/Libraries
Requires: gawk

# RH/Fedora compatibility
Provides: krb5-libs = %EVR

%package -n lib%name-ldap
Summary: The shared Kerberos 5 libraries, LDAP support
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name-devel
Summary: Development files needed to compile Kerberos 5 programs
Group: System/Libraries
Requires: lib%name = %version-%release
%{?_with_ldap:Requires: lib%name-ldap = %version-%release}
Requires: libcom_err-devel
Provides: %name-services = %version-%release
Provides: %name-clients = %version-%release
Obsoletes: %name-services < %version-%release
Obsoletes: %name-clients < %version-%release

%if_without verto
%package -n libverto
Version: 0.0.%version
Summary: verto shared libraries (bootstrap build)
Group: System/Legacy libraries

%description -n libverto
This is a temporary libverto package built within krb5;
only used for bootstrap.
%endif

%package kdc
Group: System/Servers
Summary: The Kerberos 5 Key Distribution Center
Requires: %name-kadmin = %version-%release
Requires: lib%name = %version-%release
Requires: lib%name-ldap = %version-%release
Requires: libverto-libev
Provides: %name-server = %version-%release
Obsoletes: %name-server < %version-%release

%package kadmin
Group: System/Servers
Summary: The KDC admin programs for Kerberos 5
Requires: %name-kinit = %version-%release
Requires: lib%name = %version-%release

%package kinit
Summary: Kerberos 5 programs for use on workstations
Group: System/Base
Requires: lib%name = %version-%release
Provides: %name-workstation = %version-%release
Obsoletes: %name-workstation < %version-%release

%package ksu
Summary: Kerberized super-user
Group: System/Base
Requires(pre,postun): control
Requires: lib%name = %version-%release
Conflicts: %name-kinit < %version-%release

%package doc
Group: Books/Computer books
Summary: Kerberos 5 documentation
BuildArch: noarch

%description -n lib%name
Kerberos is a network authentication system.  This package contains
the shared libraries needed by Kerberos 5.  If you are using Kerberos,
you need to install this package.

%description -n lib%name-ldap
Kerberos is a network authentication system.  This package contains
the shared Kerberos 5 libraries needed for LDAP backend support.

%description -n lib%name-devel
Kerberos is a network authentication system.  This package contains the
header files and libraries needed for compiling Kerberos 5 programs.
If you want to develop Kerberos-aware programs, you need to install
this package.

%description kdc
Kerberos is a network authentication system.
This package contains the programs that must be installed
on a Kerberos 5 Key Distribution Center.

%description kadmin
Kerberos is a network authentication system.
This package contains set of programs helping to manage
a Kerberos 5 Key Distribution Center.

%description kinit
Kerberos is a network authentication system.
This package contains the basic Kerberos programs.
If your network uses Kerberos, this package should be installed
on every workstation.

%description ksu
Kerberos is a network authentication system.
This package contains ksu program, which is a Kerberized version
of the su program that has two missions: to securely change the
real and effective user ID to that of the target user, and to
create a new security context.

%description doc
Kerberos is a network authentication system.
This packages contains documentation bundled with
MIT Kerberos.

# }}}

%prep
%setup

# fedora patches:
%patch60 -p1 -b .pam
%patch63 -p1 -b .selinux-label
%patch23 -p1 -b .dns
%patch39 -p1 -b .api
%patch86 -p1 -b .debuginfo
# Apply when the hard-wired or configured default location is
# DIR:/run/user/%%{uid}/krb5cc.
%patch129 -p1 -b .run_user_0

%patch200 -p2 -b .default_keytab_group
%patch201 -p1

%patch301 -p1
%patch302 -p1
%patch303 -p1
%patch304 -p1
%patch305 -p1
%patch306 -p1
%patch156 -p1

# Generate an FDS-compatible LDIF file.
inldif=src/plugins/kdb/ldap/libkdb_ldap/kerberos.ldif
cat > '60kerberos.ldif' << EOF
# This is a variation on kerberos.ldif which 389 Directory Server will like.
dn: cn=schema
EOF
egrep -iv '(^$|^dn:|^changetype:|^add:)' $inldif | \
sed -r 's,^		,                ,g' | \
sed -r 's,^	,        ,g' >> 60kerberos.ldif
touch -r $inldif 60kerberos.ldif

%ifarch %e2k
sed -r -i 's, error=(pointer-arith|uninitialized),,g' \
   src/aclocal.m4 src/configure*
%endif

%build
# Go ahead and supply tcl info, because configure doesn't know how to find it.
# . %_libdir/tclConfig.sh

DEFINES="-D_FILE_OFFSET_BITS=64" ; export DEFINES
%add_optflags -I/usr/include/et
%add_optflags -DKRB5_DNS_LOOKUP

# Set this so that configure will have a value even if the current version of
# autoconf doesn't set one.
runstatedir=%_runtimedir; export runstatedir

pushd src
autoreconf --verbose --force
%configure \
	--enable-shared --disable-static \
	--localstatedir=%_localstatedir/kerberos \
	--with-system-et \
	--with-system-ss \
	%{?_with_verto:--with-system-verto} \
	%{subst_with ldap} \
	%{subst_with selinux} \
        %{subst_with lmdb} \
	--enable-dns-for-realm \
	--enable-pkinit \
%if_without bootstrap
	--with-pkinit-crypto-impl=openssl \
	--with-tls-impl=openssl \
%endif
	--with-pam \
	--with-netlib=-lresolv \
	--disable-rpath \
	#

# dejagnu tests disabled
# 	--with-tcl=%_libdir \
%make_build
popd

# Sanity check the KDC_RUN_DIR.
configured_kdcrundir=`grep KDC_RUN_DIR src/include/osconf.h | awk '{print $NF}'`
configured_kdcrundir=`eval echo $configured_kdcrundir`
if test "$configured_kdcrundir" != %_runtimedir/krb5kdc ; then
    exit 1
fi

%if_with doc
# Build the docs.
make -C src/doc paths.py version.py
cp src/doc/paths.py doc/
mkdir -p build-man build-html build-pdf
sphinx-build-3 -a -b man   -t pathsubs doc build-man
sphinx-build-3 -a -b html  -t pathsubs doc build-html
rm -fr build-html/_sources
sphinx-build-3 -a -b latex -t pathsubs doc build-pdf
make -C build-pdf
%endif

# We need to cut off any access to locally-running nameservers, too.
%__cc -fPIC -shared -o noport.so -Wall -Wextra %SOURCE100

%check
# NOTE(iv@): this test hangs for too long, look at this later
echo > src/tests/t_iprop.py

# skip this test, because getaddrinfo with flag AI_ADDRCONFIG return error in hasher
echo > src/tests/t_kprop.py

make -C src check TMPDIR=%_tmppath OFFLINE=yes PYTESTFLAGS="-v"

%install

make -C src install \
    DESTDIR=%buildroot \
    INSTALL_SETUID='install -m0755' \
    EXAMPLEDIR=%_docdir/examples

# Server init scripts, sample client config file and sample KDC config files.
tar xf %SOURCE2 -C %buildroot

mkdir -p %buildroot%_sysconfdir/krb5.conf.d

# Fix preporcessor loop
# sed -i 's,<krb5/krb5.h>,<krb5/krb5/krb5.h>,' %buildroot%_includedir/krb5/krb5.h

# Relocate *some* shared libraries
mkdir -p %buildroot/%_lib
for lib in libgssapi_krb5 libk5crypto libkrb5 libkrb5support; do
  mv %buildroot%_libdir/${lib}.so.* %buildroot/%_lib
  ln -snf ../../%_lib/`readlink %buildroot%_libdir/${lib}.so` %buildroot%_libdir/${lib}.so
done

# Fix binaries clashes
mv -f %buildroot%_bindir/uuclient %buildroot%_bindir/%name-uuclient
mv -f %buildroot%_sbindir/uuserver %buildroot%_sbindir/%name-uuserver

# Where per-user keytabs live by default.
mkdir -p %buildroot%_localstatedir/kerberos/krb5/user

# Parent of configuration file for list of loadable GSS mechs ("mechs").  This
# location is not relative to sysconfdir, but is hard-coded in g_initialize.c.
mkdir -m 755 -p %buildroot%_sysconfdir/gss
# Parent of groups of configuration files for a list of loadable GSS mechs
# ("mechs").  This location is not relative to sysconfdir, and is also
# hard-coded in g_initialize.c.
mkdir -m 755 -p %buildroot%_sysconfdir/gss/mech.d

%if_with doc
# Install docs
mkdir -p %buildroot%_docdir/pdf
cp build-pdf/*.pdf %buildroot%_docdir/pdf/
cp -R build-html/ %buildroot/%_docdir/
cp -p src/plugins/kdb/ldap/libkdb_ldap/kerberos.{ldif,schema} %buildroot%_docdir/
%endif

# cleanups
rm -rf %buildroot%_libdir/krb5/plugins/preauth/test.so
rm -rf %buildroot%_datadir/gnats
rm -rf %buildroot%_mandir/cat*
touch %buildroot%_sysconfdir/krb5.keytab

%find_lang mit-krb5

%if_without bootstrap
%post kdc
%post_service krb5kdc
%post_service kadmin
%post_service kprop

%preun kdc
%preun_service krb5kdc
%preun_service kadmin
%preun_service kprop
%endif

%pre -n lib%name
/usr/sbin/groupadd -r -f _keytab

%pre ksu
%pre_control ksu

%post ksu
%post_control -s wheelonly ksu


%triggerpostun -n lib%name -- lib%name < 1.14.4-alt2
if [ -f %_sysconfdir/krb5.keytab ]; then
    chown :_keytab %_sysconfdir/krb5.keytab
    chmod g+r %_sysconfdir/krb5.keytab
fi

%files -n lib%name -f mit-krb5.lang
%config(noreplace) %_sysconfdir/krb5.conf
%ghost %config(noreplace) %attr(640,root,_keytab) %_sysconfdir/krb5.keytab
%dir %_sysconfdir/gss
%dir %_sysconfdir/gss/mech.d
%dir %_sysconfdir/krb5.conf.d
%dir %_localstatedir/kerberos
%dir %_localstatedir/kerberos/krb5
%dir %_localstatedir/kerberos/krb5/user

/%_lib/lib*.so.*

%_libdir/libgssrpc.so.*
%_libdir/libkadm5clnt_mit.so.*
%_libdir/libkadm5srv_mit.so.*
%_libdir/libkdb5.so.*
%_libdir/libkrad.so.*

%dir %_libdir/%name
%dir %_libdir/%name/plugins
%dir %_libdir/%name/plugins/kdb
%dir %_libdir/%name/plugins/preauth
%dir %_libdir/%name/plugins/tls
%_libdir/%name/plugins/kdb/db2.so
%if_with lmdb
%_libdir/%name/plugins/kdb/klmdb.so
%endif
%_libdir/%name/plugins/preauth/otp.so
%_libdir/%name/plugins/preauth/pkinit.so
%_libdir/%name/plugins/preauth/spake.so
%_libdir/%name/plugins/tls/k5tls.so

%_man5dir/krb5.conf.5*
%_man7dir/kerberos.7*

%if_with ldap
%files -n lib%name-ldap
%_libdir/libkdb_ldap.so.*
%_libdir/%name/plugins/kdb/kldap.so
%endif

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_bindir/gss-client
%_bindir/sclient
%_bindir/krb5-config
%_bindir/sim_client
%_bindir/%name-uuclient
%_sbindir/%name-uuserver
%_sbindir/gss-server
%exclude %_sbindir/krb5-send-pr
%_sbindir/sim_server
%_sbindir/sserver
%_man1dir/sclient.1*
%_man1dir/krb5-config.1*
%_man8dir/sserver.8*
%_pkgconfigdir/*

%if_without verto
%files -n libverto
%_prefix/lib*/libverto.so.*
%endif

%if_without bootstrap
%files kdc
%dir %_localstatedir/kerberos/krb5kdc
%config(noreplace) %_localstatedir/kerberos/krb5kdc/kdc.conf
%config(noreplace) %_localstatedir/kerberos/krb5kdc/kadm5.acl

%config(noreplace) %_sysconfdir/sysconfig/kadmin
%config(noreplace) %_sysconfdir/sysconfig/krb5kdc

%_initdir/kadmin
%_initdir/krb5kdc
%_initdir/kprop

%systemd_unitdir/kadmin.service
%systemd_unitdir/kprop.service
%systemd_unitdir/krb5kdc.service

%_sbindir/kadmin.local
%_sbindir/kadmind
%_sbindir/kdb5_util
%{?_with_ldap:%_sbindir/kdb5_ldap_util}
%_sbindir/kprop
%_sbindir/kproplog
%_sbindir/kpropd
%_sbindir/krb5kdc

%_man5dir/kadm5.acl.5*
%_man5dir/kdc.conf.5*
%_man8dir/kadmin.local.8*
%_man8dir/kadmind.8*
%_man8dir/kdb5_util.8*
%{?_with_ldap:%_man8dir/kdb5_ldap_util.8*}
%_man8dir/kprop.8*
%_man8dir/kproplog.8*
%_man8dir/kpropd.8*
%_man8dir/krb5kdc.8*
%endif

%files kadmin
%_bindir/kadmin
%_bindir/ktutil
%_man1dir/kadmin.1*
%_man1dir/ktutil.1*

%_bindir/k5srvutil
%_man1dir/k5srvutil.1*

%files kinit
%_bindir/kdestroy
%_bindir/kinit
%_bindir/klist
%_bindir/kpasswd
%_bindir/kvno
%_bindir/kswitch

%_man1dir/kdestroy.1*
# %%_man1dir/kerberos.1*
%_man1dir/kinit.1*
%_man1dir/klist.1*
%_man1dir/kpasswd.1*
%_man1dir/kvno.1*
%_man1dir/kswitch.1*
%_man5dir/.k5login.5*
%_man5dir/k5login.5*
%_man5dir/.k5identity.5*
%_man5dir/k5identity.5*

%files ksu
%config(noreplace) %_sysconfdir/pam.d/ksu
%_controldir/ksu
%_bindir/ksu
%_man1dir/ksu.1*


%if_with doc
%files doc
%doc %_docdir
%endif

# {{{ changelog

%changelog
