# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: less
Version: 530
Release: alt3

Summary: A text file browser similar to more, but better
License: GPLv3+
Group: File tools
Url: http://www.greenwoodsoftware.com/less/
Packager: Alexey Gladkov <legion@altlinux.ru>

# http://www.greenwoodsoftware.com/less/less-%version.tar.gz
Source:   less-%version.tar
Source1:  http://www.greenwoodsoftware.com/less/faq.html
Source2:  lesspipe
Source3:  lessfile
Source4:  lesspipe.sh
Source5:  lessfile.sh
Source6:  lessclose.sh
Source7:  zless
Source8:  zless.1
Source9:  lzless
Source10: lzless.1
Source11: lesspipe.1
Source12: less.sh
Source13: less.csh
Source14: lesspipe-color.sh

Patch001: 0001-ALT-Add-AC_GNU_SOURCE.patch
Patch002: 0002-Add-old-bot-option-to-manpage.patch
Patch003: 0003-Add-old-bot-option-to-help.patch
Patch004: 0004-Process-old-bot-at-start.patch
Patch005: 0005-Fix-pcre.h-include-path.patch
Patch006: 0006-Set-LESSCOLOR-env-variable-if-R-was-specified.patch

Requires: file >= 4.26-alt3, mktemp >= 1:1.3.1

# due to bzless
Conflicts: bzip2 < 0:1.0.1-ipl6mdk
# due to zmore
Conflicts: gzip-utils < 0:1.3.5-alt1
# due to lzless
Conflicts: lzma-utils < 4.32.7-alt3

BuildRequires: libtinfo-devel libpcre-devel

%description
The less utility is a text file browser that resembles more, but has
more capabilities. less allows you to move backwards in the file as
well as forwards. Since less doesn't have to read the entire input file
before it starts, less starts up more quickly than text editors (for
example, vi).

%prep
%setup

%patch001 -p2
%patch002 -p2
%patch003 -p2
%patch004 -p2
%patch005 -p2
%patch006 -p2

install -pm644 %_sourcedir/faq.html .
bzip2 -9k NEWS

%build
autoconf
%configure --with-regex=pcre
%make_build

%install
mkdir -p %buildroot{%_sysconfdir/profile.d,%_datadir/less}
%makeinstall
install -pm755 %_sourcedir/{lesspipe,lessfile,zless,lzless} \
	%buildroot%_bindir/
install -pm755 %_sourcedir/{lesspipe,lesspipe-color,lessfile,lessclose}.sh \
	%buildroot%_datadir/less/
install -pm644 %_sourcedir/{lesspipe,zless,lzless}.1 \
	%buildroot%_man1dir/
install -pm755 %_sourcedir/less.{sh,csh} \
	%buildroot%_sysconfdir/profile.d/
ln -s zless %buildroot%_bindir/zmore
ln -s zless %buildroot%_bindir/bzmore
ln -s zless %buildroot%_bindir/bzless
ln -s zless %buildroot%_bindir/xzmore
ln -s zless %buildroot%_bindir/xzless
ln -s lzless %buildroot%_bindir/lzmore
ln -s zless.1 %buildroot%_man1dir/zmore.1
ln -s zless.1 %buildroot%_man1dir/bzmore.1
ln -s zless.1 %buildroot%_man1dir/bzless.1
ln -s zless.1 %buildroot%_man1dir/xzmore.1
ln -s zless.1 %buildroot%_man1dir/xzless.1
ln -s lzless.1 %buildroot%_man1dir/lzmore.1
ln -s lesspipe.1 %buildroot%_man1dir/lessfile.1

%files
%config(noreplace) %_sysconfdir/profile.d/less.*
%_bindir/*
%_datadir/less
%_man1dir/*
%doc NEWS.bz2 *.html

%changelog
