%define ver_major 12.10
%define api_ver 0.1

Name: libappindicator
Version: %ver_major.0
Release: alt12.p10
Summary: Application indicators library

Group: System/Libraries
License: LGPLv2 and LGPLv3
Url: https://launchpad.net/%name
Packager: Anton Midyukov <antohami@altlinux.org>

Source: https://launchpad.net/%name/%ver_major/%version/+download/%name-%version.tar.gz
Patch: 0001_Fix_mono_dir.patch
Patch1: 0002_libappindicator-no-Werror.patch
Patch2: libappindicator-12.10.0-alt-application-service-marshal.patch
Patch3: nopython.patch
BuildRequires(pre): gcc
BuildRequires: vala-tools gtk-doc
BuildRequires: libdbus-glib-devel
BuildRequires: libdbusmenu-gtk3-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libgtk+2-devel libindicator-devel libdbusmenu-gtk2-devel
BuildRequires: libgtk+3-devel libgtk+3-gir-devel
BuildRequires: libindicator-gtk3-devel
BuildRequires: rpm-build-gir

%description
A library to allow applications to export a menu into the Unity Menu bar. Based
on KSNI it also works in KDE and will fallback to generic Systray support if
none of those are available.

%package gtk3
Summary: Application indicators library - GTK 3
Group: System/Libraries

%description gtk3
A library to allow applications to export a menu into the Unity Menu bar. Based
on KSNI it also works in KDE and will fallback to generic Systray support if
none of those are available.

This package contains the GTK 3 version of this library.

%package gtk3-devel
Summary: Development files for %name-gtk3
Group: Development/Other
Requires: %name-gtk3 = %EVR

%description gtk3-devel
This package contains the development files for the appindicator-gtk3 library.

%package gtk3-gir
Summary: GObject introspection data for the %name-gtk3
Group: System/Libraries
Requires: %name-gtk3 = %EVR

%description gtk3-gir
This package provides GObject introspection data for the %name-gtk3.

%package gtk3-gir-devel
Summary: GObject introspection devel data for the %name-gtk3
Group: Development/Other
BuildArch: noarch
Requires: %name-gtk3-gir = %EVR

%description gtk3-gir-devel
This package provides GObject introspection devel data for the %name-gtk3

%package devel-doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch

%description devel-doc
This package contains the documentation for the appindicator libraries.

%prep
%setup
%patch0 -p1 -b .monodir
%patch1 -p2
#patch2 -p2
%patch3 -p1

sed -i "s#gmcs#mcs#g" configure.ac

%build
%define opts --disable-static --disable-gtk-doc --disable-dumper
%define _configure_script ../configure

%autoreconf
export CFLAGS="%optflags $CFLAGS -Wno-deprecated-declarations"

mkdir build-gtk2 build-gtk3

pushd build-gtk2
%configure %opts --with-gtk=2 --disable-python --enable-introspection=no
%make -j1
popd

pushd build-gtk3
%configure %opts --with-gtk=3 --disable-python
%make -j1
popd

%install
pushd build-gtk2
%makeinstall_std
popd

pushd build-gtk3
%makeinstall_std
popd

find %buildroot -type f -name '*.la' -delete

%files
%_libdir/libappindicator.so.*
%doc AUTHORS README COPYING COPYING.LGPL.2.1

%files gtk3
%_libdir/libappindicator3.so.*

%files gtk3-gir
%_typelibdir/AppIndicator3-%api_ver.typelib

%files gtk3-devel
%dir %_includedir/libappindicator3-%api_ver/
%dir %_includedir/libappindicator3-%api_ver/libappindicator/
%_includedir/libappindicator3-%api_ver/libappindicator/*.h
%_libdir/libappindicator3.so
%_pkgconfigdir/appindicator3-%api_ver.pc
%_vapidir/appindicator3-%api_ver.vapi
%_vapidir/appindicator3-%api_ver.deps

%files gtk3-gir-devel
%_girdir/AppIndicator3-%api_ver.gir

%files devel-doc
%dir %_datadir/gtk-doc/
%dir %_datadir/gtk-doc/html/
%doc %_datadir/gtk-doc/html/*

%changelog
