%define ver_major 2.24
%def_disable static

Name: libbonoboui
Version: %ver_major.5
Release: alt1

Summary: Bonobo user interface components
License: LGPL
Group: System/Libraries
Url: ftp://ftp.gnome.org

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2

# From configure.in
%define libgnomecanvas_ver 1.116.0
%define libbonobo_ver 2.13.0
%define libgnome_ver 2.13.7
%define libxml2_ver 2.4.20
%define gconf_ver 1.1.9
%define gtk_ver 2.6.0
%define glib_ver 2.6.0
%define glade_ver 1.99.11
%define gtk_doc_ver 1.0

BuildPreReq: rpm-build-gnome gnome-common

# From configure.in
BuildPreReq: intltool >= 0.40.0
BuildPreReq: libpango-devel libpopt-devel
BuildPreReq: libXt-devel libX11-devel
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libbonobo-devel >= %libbonobo_ver
BuildPreReq: libgnomecanvas-devel >= %libgnomecanvas_ver
BuildPreReq: libgnome-devel >= %libgnome_ver
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libglade-devel >= %glade_ver
BuildPreReq: libGConf-devel >= %gconf_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver

%description
Bonobo is a component system based on CORBA, used by the GNOME
desktop. libbonoboui contains the user interface related components
that come with Bonobo.

%package devel
Summary: Develompment libraries and headers for %name
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
Bonobo is a component system based on CORBA, used by the GNOME desktop.
libbonoboui contains GUI components that come with Bonobo.

This package contains header files used to compile programs that use
libbonoboui.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Bonobo is a component system based on CORBA, used by the GNOME desktop.
libbonoboui contains GUI components that come with Bonobo.

This package contains development documentation for %name

%if_enabled static
%package devel-static
Summary: Static libraries for %name
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description devel-static
Bonobo is a component system based on CORBA, used by the GNOME desktop.
libbonoboui contains GUI components that come with Bonobo.

This package contains libraries used to compile statically linked
programs that use %name.
%endif

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

%build
%configure \
	%{subst_enable static}

%make

%install
%make_install DESTDIR=%buildroot install

bzip2 -9f ChangeLog NEWS

# development diocumentation.
mkdir -p %buildroot%_docdir/%name-devel-%version
cp doc/{*.txt,*.dtd,*.html,*.xml} %buildroot%_docdir/%name-devel-%version/

%find_lang %name-2.0

%files -f %name-2.0.lang
%_libdir/*.so.*
%_libdir/libglade/*/*.so
%dir %_datadir/gnome-2.0
%dir %_datadir/gnome-2.0/ui
%doc AUTHORS ChangeLog* NEWS* README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
# TODO: Maybe move bonobo-browser into a separate package?
%_bindir/bonobo-browser
%_bindir/test-moniker
%_datadir/gnome-2.0/ui/bonobo-browser.xml
%_desktopdir/*
# TODO: And samples, too
%_libdir/bonobo-2.0/samples/*
%bonobo_serversdir/*.server
%_datadir/gnome-2.0/ui/Bonobo_Sample*.xml

%files devel-doc
%_gtk_docdir/*
%_docdir/%name-devel-%version

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/libglade/*/*.a
%endif

%exclude %_libdir/libglade/2.0/*.la

%changelog
