# [armh] hash: [armh] /usr/src/tmp/rpm-tmp.97635: line 128: 754225 Segmentation fault
%ifarch armh
%def_without test
%endif
%define _unpackaged_files_terminate_build 1

Name: libbotan
Version: 2.19.1
Release: alt2.1

Summary: A C++ Crypto Library
License: BSD
Group: System/Libraries

Url: http://botan.randombit.net

# Source-url: https://github.com/randombit/botan/archive/%version.tar.gz
Source: %name-%version.tar
Patch2000: %name-e2k-simd.patch

BuildRequires: rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: liblzma-devel bzlib-devel libssl-devel zlib-devel
BuildRequires: boost-asio-devel
BuildRequires: %_bindir/sphinx-build %_bindir/rst2man

%description
Botan is a C++ library that provides support for many common
cryptographic operations, including encryption, authentication, and
X.509v3 certificates and CRLs. A wide variety of algorithms is
supported, including RSA, DSA, DES, AES, MD5, and SHA-1.

%package devel
Summary: Headers for %name
Group: Development/C
Requires: %name = %EVR
Conflicts: libbotan1.11-devel

%description devel
Headers for building software that uses %name

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description doc
%summary

%package -n python3-module-botan
Summary: Python extensions for botan
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-botan
Python extensions for botan

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%build
export CXXFLAGS="${CXXFLAGS:-%optflags}"

python3 ./configure.py \
	--prefix=%prefix \
	--libdir=%_libdir \
	--docdir=%_defaultdocdir \
	--includedir=%_includedir \
	--disable-static-library \
	--with-debug-info \
	--with-bzip2 \
	--with-lzma \
	--with-zlib \
	--with-boost \
	--with-openssl \
	--with-python-versions=%__python3_version \
	--with-documentation \
	--with-sphinx \
	--with-rst2man \
	%nil

%make_build

%install
%makeinstall_std

rm -rf %buildroot%_defaultdocdir/botan-%version/manual/{.doctrees,.buildinfo}

%check
LD_LIBRARY_PATH=. ./botan-test

%files
%_libdir/*.so.*

%files devel
%_bindir/*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man1dir/botan.1*

%files doc
%doc %_defaultdocdir/botan-%version

%files -n python3-module-botan
%python3_sitelibdir/*.py
%python3_sitelibdir/__pycache__/*

%changelog
