%def_disable snapshot

%define _name cairomm
%define ver_major 1.16
%define api_ver %ver_major

%def_enable docs
# boost.pc required
%def_disable check

Name: lib%_name%api_ver
Version: %ver_major.0
Release: alt1

Summary: This library provides a C++ interface to cairo
License: LGPL-2.0
Group: System/Libraries
Url: https://cairographics.org/cairomm
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%if_disabled snapshot
Source: https://www.cairographics.org/releases/%_name-%version.tar.xz
%else
Vcs: git://git.cairographics.org/git/cairomm
Source: %_name-%version.tar
%endif

%define cairo_ver 1.12
%define sigc_ver 3.0.0

BuildRequires(pre): meson
BuildRequires: gcc-c++ mm-common
BuildRequires: libcairo-devel >= %cairo_ver libsigc++3-devel >= %sigc_ver
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}
%{?_enable_check:BuildRequires: boost-test-devel fontconfig-devel}

%description
This library provides a C++ interface to cairo.

%package devel
Summary: Headers and development files of %name library
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of %name library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains documentation needed for developing %_name applications.

%prep
%setup -n %_name-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true} \
    %{?_enable_check:-Dbuild-tests=true
    -Dboost-shared=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/cairomm-%api_ver
%_libdir/cairomm-%api_ver
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled docs
%files devel-doc
%_datadir/devhelp/books/%_name-%api_ver/
%_datadir/doc/%_name-%api_ver/
%endif

%changelog
