Name: libcap
Version: 2.69
Release: alt1
Epoch: 1

Summary: Library for getting and setting POSIX.1e capabilities
License: GPL-2.0-only or BSD-3-Clause
Group: System/Libraries
Url: https://sites.google.com/site/fullycapable/
# git://git.altlinux.org/gears/l/libcap.git
Source: %name-%version-%release.tar
Vcs: https://git.kernel.org/pub/scm/libs/libcap/libcap.git

# For backwards compatibility.
%{expand:%%global lib_suffix %(test %_lib != lib64 && echo %%nil || echo '()(64bit)')}
Provides: %name.so.1%lib_suffix

BuildRequires: gperf
BuildRequires(pre): libpam-devel

%set_pam_name pam_cap

%package utils
Summary: Utilities for getting and setting POSIX.1e capabilities
Group: System/Base
Requires: %name = %EVR

%package devel
Summary: Development environment for libcap
Group: Development/C
Requires: %name = %EVR

%package devel-static
Summary: Static libcap library
Group: Development/C
Requires: %name-devel = %EVR

%package -n %pam_name
Summary: PAM module for enforcing inheritable capability sets
Group: System/Base
Provides: pam_cap = %EVR
Obsoletes: pam_cap < %epoch:%version
Requires: %name = %EVR

%description
This is a shared library for getting and setting POSIX.1e
(formerly POSIX 6) draft 15 capabilities.

%description utils
This packages contains utilities for getting and setting
POSIX.1e (formerly POSIX 6) draft 15 capabilities.

%description devel
The development library, header files, and documentation
for building applications dealing with POSIX.1e
(formerly POSIX 6) draft 15 capabilities.

%description devel-static
This is a static library for getting and setting POSIX.1e
(formerly POSIX 6) draft 15 capabilities.

%description -n %pam_name
The purpose of this PAM module is to enforce inheritable capability sets
for users specified in configuration file.

%prep
%setup -n %name-%version-%release

%build
%global optflags_lto %optflags_lto -ffat-lto-objects
%make_build CC=%__cc CFLAGS="%optflags" FORCELINKPAM=yes \
	GOLANG=no lib=%_lib DEBUG= INDENT=

%install
%makeinstall_std lib=%_lib RAISE_SETFCAP=no FORCELINKPAM=yes
install -pDm600 pam_cap/capability.conf %buildroot/etc/security/capability.conf

# Relocate development library from /%_lib/ to %_libdir/.
mkdir -p "%buildroot%_libdir"
for l in libcap libpsx; do
	symlink="%buildroot/%_lib/"$l".so"
	soname=$(readlink "$symlink")
	rm "$symlink"
	ln -rsnf %buildroot/%_lib/"$soname" "%buildroot%_libdir/"$l".so"
	mv %buildroot/%_lib/"$l".a %buildroot%_libdir/
done

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
%make_build CC=%__cc CFLAGS="%optflags" lib=%_lib DEBUG= INDENT= test

%files
/%_lib/*.so.*

%files utils
/sbin/*
%_man1dir/*
%_man8dir/*

%files devel
%_libdir/*.so
%_includedir/sys/*.h
%_pkgconfigdir/*.pc
%_man3dir/*
%doc CHANGELOG License README *.txt pgp.keys.asc doc/capability.md progs/*.c

%files devel-static
%_libdir/*.a

%files -n %pam_name
%config(noreplace) /etc/security/capability.conf
%_pam_modules_dir/*

%changelog
