%def_enable cddb

Name: libcdio
Version: 2.1.0
Release: alt1

Summary: CD-ROM/CD-image access library
License: GPLv3+
Group: System/Libraries
Url: http://www.gnu.org/software/%name/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

#Source: ftp://ftp.gnu.org/gnu/libcdio/%name-%version.tar.gz
# git://git.sv.gnu.org/libcdio.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ libncurses-devel help2man makeinfo
%{?_enable_cddb:BuildRequires: libcddb-devel}

%description
This library is to encapsulate CD-ROM reading and control. Applications
wishing to be oblivious of the OS- and device-dependant properties of a
CD-ROM can use this library.

%package -n libcdio++
Summary: C++ wrappers to the CD-ROM/CD-image access library
Group: System/Libraries
Requires: %name = %version-%release

%description -n libcdio++
These C++ libraries provide object-oriented wrappers to the libcdio APIs.

%package devel
Summary: %name development files
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides %name development files.

%package -n libcdio++-devel
Summary: Development files for libcdio C++ wrappers
Group: Development/C++
Requires: libcdio++ = %version-%release
Requires: %name-devel = %version-%release

%description -n libcdio++-devel
This package provides development files for C++ wrappers to libcdio APIs.

%package utils
Summary: A simple utilities which read and displayings CD info.
Group: File tools
Requires: %name = %version-%release

%description utils
This package provides simple utilities which read and displayings CD
info.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	%{subst_enable cddb} \
	--enable-maintainer-mode \
	--disable-static
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS README NEWS* THANKS TODO
%_libdir/*.so.*
%_infodir/%name.info*
%exclude %_libdir/*++.so.*

%files devel
%_includedir/cdio
%_libdir/*.so
%_pkgconfigdir/*.pc
%exclude %_libdir/*++.so
%exclude %_pkgconfigdir/*++.pc

%files -n libcdio++
%_libdir/*++.so.*

%files -n libcdio++-devel
%_includedir/cdio++
%_libdir/*++.so
%_pkgconfigdir/*++.pc

%files utils
%_bindir/*
%_man1dir/*.1*

%changelog
