%define ver_major 0.6

Name: libcroco
Version: %ver_major.13
Release: alt2

Summary: A CSS2 parsing library
License: LGPL-2.0
Group: System/Libraries
Url: ftp://ftp.gnome.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Patch: %name-0.6.13-alt-croco-config.patch

%define glib_ver 2.0
%define libxml2_ver 2.4.23

%def_with apidocs

Requires: glib2 >= %glib_ver
Requires: libxml2 >= %libxml2_ver

BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libxml2-devel >= %libxml2_ver

BuildRequires: zlib-devel gtk-doc
%{?_with_apidocs:BuildRequires: doxygen}

%description
Libcroco is a standalone CSS2 parsing and manipulation library.

%package devel
Summary: Libraries and include files for developing with %name
Group: Development/C
Requires: %name = %version-%release
Requires: pkgconfig >= 0.8
Requires: glib2-devel >= %glib_ver
Requires: libxml2-devel >= %libxml2_ver

%description devel
This package provides the necessary development libraries and include
files to develop with %name.

%if_with apidocs
%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains development documentation for %name
%endif

%package -n css-utils
Summary: Command line CSS tools
Group: Text tools
Requires: %name = %version-%release

%description -n css-utils
This package provides csslint - program to parse CSS files. It is useful
for detecting errors both in CSS code and in the CSS parser itself.

%prep
%setup
%patch

%build
%autoreconf
%configure --disable-static

%make_build
%{?_with_apidocs:%make_build apidoc}

%install
%makeinstall_std

%check
%make check

%files
%_libdir/*.so.*
%doc AUTHORS ChangeLog NEWS README TODO

%files devel
%_bindir/croco-%ver_major-config
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*
%if_with apidocs
%doc docs/{apis/html,examples}
%endif

%if_with apidocs
%files devel-doc
%_datadir/gtk-doc/html/%name/
%endif

%files -n css-utils
%_bindir/csslint-%ver_major

%changelog
