Name: libdb1
Version: 1.85
Release: alt8

Summary: Berkeley database library version %version
License: BSD
Group: System/Libraries
Url: http://www.sleepycat.com/

Provides: libdb1.so.2, db1 = %version
Obsoletes: db1
Conflicts: glibc < 2.1.90

# ftp://ftp.sleepycat.com/releases/db.%version.tar.gz
Source: db.%version.tar
Source1: db_dump185.c
Patch1: db.%version.patch
Patch2: db.%version.s390.patch
Patch3: db.%version.nodebug.patch

%package -n db1-utils
Summary: Command line tools for managing Berkeley DB databases
Group: Databases
Requires: %name = %version-%release
Conflicts: db4-utils < 0:4.3.29-alt3

%package devel
Summary: Development environment for Berkeley database library version %version
Group: Development/C
Requires: %name = %version-%release, db1-utils = %version-%release
Provides: db1-devel = %version
Obsoletes: db1-devel
Conflicts: glibc-devel < 2.1.90

%package devel-static
Summary: Static libraries for Berkeley database library version %version
Group: Development/C
Provides: db1-devel-static = %version
Obsoletes: db1-devel-static
Requires: %name-devel = %version-%release
Requires: glibc-devel-static

%package doc
Summary: Documentation for Berkeley database library version %version
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description
The Berkeley Database (Berkeley DB) is a programmatic toolkit that provides
embedded database support for both traditional and client/server applications.
It should be installed if compatibility is needed with databases created
with db1.

This library used to be part of the glibc package.
Since glibc-2.1.90, it is independent package.

%description -n db1-utils
The Berkeley Database (Berkeley DB) is a programmatic toolkit that provides
embedded database support for both traditional and client/server applications.

This package contains command line tools for managing Berkeley DB databases.

%description devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that provides
embedded database support for both traditional and client/server applications.

This package contains the header files, libraries for building programs
which use Berkeley DB.

%description devel-static
The Berkeley Database (Berkeley DB) is a programmatic toolkit that provides
embedded database support for both traditional and client/server applications.

This package contains the static library required for building statically linked
programs which use Berkeley DB.

%description doc
The Berkeley Database (Berkeley DB) is a programmatic toolkit that provides
embedded database support for both traditional and client/server applications.

This package contains documentation for Berkeley DB version %version.

%prep
%setup -n db.%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
install -pm644 %_sourcedir/db_dump185.c PORT/linux/

%build
%add_optflags -fno-strict-aliasing
%make_build -C PORT/linux OORG="%optflags"
bzip2 -9 docs/*.ps

sed -i 's/<db\.h>/<db1\/db.h>/' PORT/include/ndbm.h

%install
mkdir -p %buildroot{/%_lib,%_bindir,%_libdir,%_includedir/db1}

sed -n '/^\/\*-/,/^ \*\//s/^.\*.\?//p' include/db.h |grep -v '^@.*db\.h' >LICENSE

pushd PORT/linux
	install -p -m755 db_dump185 %buildroot%_bindir/db1_dump185
	ln -s db1_dump185 %buildroot%_bindir/db_dump185
	sover=`echo libdb.so.* |sed -e 's/libdb\.so\.//'`
	install -pm755 libdb.so.$sover %buildroot%_libdir/%name.so.$sover
	install -pm644 libdb.a %buildroot%_libdir/%name.a
	ln -s %name.so.$sover %buildroot%_libdir/libdb.so.$sover
	ln -s %name.so.$sover %buildroot%_libdir/%name.so
popd
install -pm644 PORT/include/ndbm.h include/{db,mpool}.h \
	%buildroot%_includedir/db1/

%define docdir %_docdir/%name-%version
install -pDm644 changelog %buildroot%docdir/ChangeLog
install -pm644 README LICENSE docs/*usenix*.ps.* %buildroot%docdir/

%files
%_libdir/*.so.*
%dir %docdir
%docdir/[A-Z]*

%files -n db1-utils
%_bindir/*

%files devel
%_libdir/*.so
%_includedir/*

%files devel-static
%_libdir/*.a

%files doc
%dir %docdir
%docdir/*.ps.*

%changelog
