Name: libdnet
Version: 1.12
Release: alt4

Summary: A dumb networking library
Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/boundary/libdnet

# Don't build static library by default,
# can be overridden by 'rpmbuild --enable static ...'
%def_disable static

# Python bindings, may be enabled using 'rpmbuild --with python ...'
%def_without python

# http://libdnet.googlecode.com/files/libdnet-%version.tgz
Source: libdnet-%version.tar
Patch1: libdnet-1.12-alt-warnings.patch
Patch2: libdnet-1.12-alt-fixes.patch

BuildRequires: gcc-c++ libpcap-devel

Summary(ru_RU.UTF-8): Низкоуровневая библиотека работы с сетью

%package devel
Summary: Development libdnet library, header files, documentation and examples
Summary(ru_RU.UTF-8): Средства разработки для libdnet - библиотека, заголовки, документация и примеры
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Static libdnet library
Summary(ru_RU.UTF-8): Библиотека libdnet для статической компоновки
Group: Development/C
Requires: %name-devel = %version-%release
Requires: glibc-devel-static

%package -n dnet
Summary: A dumb networking library test program
Summary(ru_RU.UTF-8): Утилита для тестирования библиотеки libdnet
Group: Networking/Other
Requires: %name = %version-%release

%description
libdnet provides a simplified, portable interface to several low-level
networking routines, including network address manipulation, kernel
arp(4) cache and route(4) table lookup and manipulation, network
firewalling, network interface lookup and manipulation, and raw IP
packet and Ethernet frame transmission.

%description -l ru_RU.UTF-8
Библиотека libdnet предоставляет понятный и переносимый интерфейс
к низкоуровневым системным вызовам для управления следующими данными:
  * таблица сетевых интерфейсов,
  * кэш arp(4),
  * таблица маршрутизации (man 4 route),
  * правила пакетной фильтрации,
  * передача raw IP- и Ethernet-пакетов.

%description devel
libdnet provides a simplified, portable interface to several low-level
networking routines, including network address manipulation, kernel
arp(4) cache and route(4) table lookup and manipulation, network
firewalling, network interface lookup and manipulation, and raw IP
packet and Ethernet frame transmission.

This package contains the development library, it's header files,
documentation and examples needed to develop libdnet-based applications.

%description devel -l ru_RU.UTF-8
Библиотека libdnet предоставляет понятный и переносимый интерфейс
к низкоуровневым системным вызовам для управления следующими данными:
  * таблица сетевых интерфейсов,
  * кэш arp(4),
  * таблица маршрутизации (man 4 route),
  * правила пакетной фильтрации,
  * передача raw IP- и Ethernet-пакетов.

Данный пакет содержит библиотеку, необходимую для разработки приложений,
заголовочные файлы для неё, документацию и примеры программ.

%description devel-static
libdnet provides a simplified, portable interface to several low-level
networking routines, including network address manipulation, kernel
arp(4) cache and route(4) table lookup and manipulation, network
firewalling, network interface lookup and manipulation, and raw IP
packet and Ethernet frame transmission.

This package contains the static libdnet library required to develop
statically linked libdnet-based applications.

%description devel-static -l ru_RU.UTF-8
Библиотека libdnet предоставляет понятный и переносимый интерфейс
к низкоуровневым системным вызовам для управления следующими данными:
  * таблица сетевых интерфейсов,
  * кэш arp(4),
  * таблица маршрутизации (man 4 route),
  * правила пакетной фильтрации,
  * передача raw IP- и Ethernet-пакетов.

Данный пакет содержит библиотеку, необходимую для разработки приложений,
компонуемых с libdnet статически.

%description -n dnet
dnet is a simple test program for the dnet(3) library. It can be used
to compose and transmit network datagrams as a Unix-style filter (e.g.
reading from or writing to files and pipes) or modify the local system
network configuration (including the ARP cache, firewall ruleset,
network interfaces, and routing table).

%description -n dnet -l ru_RU.UTF-8
dnet является простой утилитой для тестирования одноимённой библиотеки
(см. man 3 dnet). Его можно использовать для генерации и передачи
сетевых датаграмм как обычный Юникс-фильтр (т.е. читая или записывая
данные в файлы и каналы), а также для тонкой настройки сетевых параметров
операционной системы, таких как кэш ARP, правила файрволла, сетевые интерфейсы,
таблица маршрутизации и т.д.

%if_with python

%package -n python3-module-dnet
Summary: Python bindings for libdnet, a dumb networking library
Summary(ru_RU.UTF-8): Модуль для доступа к функциям библиотеки libdnet из языка Python
Group: Development/Python3
Requires: %name = %version-%release
BuildPreReq: rpm-build-python3 python3-dev

%description -n python3-module-dnet
Python interface for accessing libdnet-provided functions.

%description -n python3-module-dnet -l ru_RU.UTF-8
Интерфейс для доступа к функциям библиотеки libdnet из программ на языке Python.

%define with_python_opt --with-python

%else # without python

%define with_python_opt %nil

%endif # with python

%prep
%setup -q
%patch1 -p1
%patch2 -p1
sed -i 's/PYTHON="python"/PYTHON="python3"/' configure.in
find config -type f -not -name acinclude.m4 -delete

%build
%autoreconf -I config
export ac_cv_dnet_linux_procfs=yes
%configure %{subst_enable static} %with_python_opt
%make_build

%install
%makeinstall_std

mkdir -p %buildroot/etc/buildreqs/files/ignore.d
cat >%buildroot/etc/buildreqs/files/ignore.d/%name-devel <<EOF
^/usr/lib/libdnet.so\$
^/usr/lib/gcc-lib/.*/libdnet.so\$
EOF

%files
%_libdir/*.so.*
%doc LICENSE README THANKS TODO

%files devel
/etc/buildreqs/files/ignore.d/%name-devel
%_bindir/*
%_libdir/*.so
%_includedir/*
%_man3dir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files -n dnet
%_sbindir/*
%_man8dir/*

%if_with python
%files -n python3-module-dnet
%python3_sitelibdir/*
%doc python/test.py python/dnet.pyx
%endif

%changelog
