%define _unpackaged_files_terminate_build 1

Name: libdqlite
Version: 1.15.1
Release: alt1
Summary: Library for distributed SQLite database
License: Apache-2.0
Group: Development/Databases
URL: https://github.com/CanonicalLtd/dqlite

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires: libuv-devel
BuildRequires: libraft-devel >= 0.17.1
BuildRequires: libsqlite3-devel

%description
This package provides the `dqlite` C library (libdqlite), which can be used
to expose a SQLite database over the network and replicate it across a cluster
of peers, using the Raft algorithm.

%package devel
Summary: Library for distributed SQLite database (development files)
Group: Development/Databases
Requires: %name = %version-%release

%description devel
This package provides the `dqlite` C library (libdqlite), which can be used
to expose a SQLite database over the network and replicate it across a cluster
of peers, using the Raft algorithm.

%prep
%setup -q -n %name-%version
%patch -p1

%build
%autoreconf
%configure --enable-replication --disable-static

%make_build all

%install
%make_install install DESTDIR=%buildroot

%files
%doc AUTHORS README.md LICENSE
%_libdir/%name.so.*

%files devel
%_includedir/dqlite.h
%_libdir/%name.so
%_pkgconfigdir/dqlite.pc

%changelog
