Name: libdrm
Version: 2.4.118
Release: alt1
Epoch: 1
Summary: Userspace interface to kernel DRM service
License: MIT
Group: System/Libraries
Url: http://dri.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): meson
BuildRequires: docbook-style-xsl libudev-devel libpciaccess-devel xorg-util-macros xsltproc python3-module-docutils

%description
This library implements the userspace interface to the kernel DRM
services. DRM stands for "Direct Rendering Manager", which is the
kernelspace portion of the "Direct Rendering Infrastructure" (DRI).
The DRI is currently used on Linux to provide hardware-accelerated
OpenGL drivers

%package devel
Summary: The drm Library and Header Files
Group: Development/C

%description devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name

%package utils
Summary: Direct Rendering Manager utilities
Group: System/X11

%description utils
Utility programs for the kernel DRM interface.
Will void your warranty.

%prep
%setup -q
%patch -p1

%build
%meson \
	-Dudev=true \
	-Dinstall-test-programs=true \
	-Dvmwgfx=enabled \
%ifarch %ix86 x86_64
	-Dintel=enabled \
%endif
%ifarch %ix86 x86_64 aarch64 ppc64le mipsel %e2k loongarch64
	-Dradeon=enabled \
	-Damdgpu=enabled \
%endif
%ifarch %ix86 x86_64 armh aarch64 ppc64le mipsel %e2k
	-Dnouveau=enabled \
%endif
%ifarch armh aarch64 loongarch64
	-Detnaviv=enabled \
%endif
%ifarch armh
	-Domap=enabled \
%endif
%ifarch armh aarch64
	-Dexynos=enabled \
	-Dtegra=enabled \
	-Dvc4=enabled \
	-Dfreedreno=enabled
%endif

%meson_build -v

%install
%meson_install

%files
%_libdir/*.so.*
%_datadir/%name

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*.3*
%_man7dir/*.7*

%files utils
%_bindir/*

%changelog
