# BEGIN SourceDeps(oneline):
BuildRequires: libgmp-devel mpir-devel
# END SourceDeps(oneline)
%add_optflags %optflags_shared
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libfplll
Version:        5.3.1
Release:        alt1_1
Summary:        LLL-reduces euclidean lattices
License:        LGPLv2+
URL:            https://github.com/fplll/fplll
Source0:        https://github.com/fplll/fplll/releases/download/%{version}/fplll-%{version}.tar.gz

BuildRequires:  gcc-c++
BuildRequires:  help2man
BuildRequires:  libmpfr-devel
BuildRequires:  libqd-devel
Source44: import.info

%description
fplll contains several algorithms on lattices that rely on
floating-point computations. This includes implementations of the
floating-point LLL reduction algorithm, offering different
speed/guarantees ratios. It contains a 'wrapper' choosing the
estimated best sequence of variants in order to provide a guaranteed
output as fast as possible. In the case of the wrapper, the
succession of variants is oblivious to the user. It also includes
a rigorous floating-point implementation of the Kannan-Fincke-Pohst
algorithm that finds a shortest non-zero lattice vector, and the BKZ
reduction algorithm.


%package        devel
Group: Development/C
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package        static
Group: System/Libraries
Summary:        Static library for %{name}

%description    static
The %{name}-static package contains a static library for %{name}.


%package        tools
Group: Engineering
Summary:        Command line tools that use %{name}
Requires:       %{name} = %{version}-%{release}

%description    tools
The %{name}-tools package contains command-line tools that expose
the functionality of %{name}.


%prep
%setup -q -n fplll-%{version}


# Fix broken test for a bool type
sed -e '/#ifndef bool/,/#endif/d' \
    -e '/#ifndef false/,/#endif/d' \
    -e '/#if false/,/#endif/d' \
    -e '/#ifndef true/,/#endif/d' \
    -e '/#if true/,/#endif/d' \
    -e '/ac_cv_type__Bool/s/\$ac_includes_default/#include <stdbool.h>/' \
    -i configure

%build
%configure --disable-silent-rules LIBS=-lpthread

# Eliminate hardcoded rpaths, and workaround libtool moving all -Wl options
# after the libraries to be linked
sed -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
    -e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' \
    -e 's|-nostdlib|-Wl,--as-needed &|' \
    -i libtool

%make_build

# Build the man pages
cd fplll
export LD_LIBRARY_PATH=$PWD/.libs
help2man -N -o ../fplll.1 ./fplll
help2man -N -o ../latsieve.1 ./latsieve
help2man -N -o ../latticegen.1 ./latticegen
cd -

%install
%makeinstall_std
rm -f %{buildroot}%{_libdir}/*.la

# Install the man pages
mkdir -p %{buildroot}%{_mandir}/man1
cp -p *.1 %{buildroot}%{_mandir}/man1

%check
LD_LIBRARY_PATH=$PWD/src/.libs make check


%files
%doc NEWS README.md
%doc --no-dereference COPYING
%{_libdir}/libfplll.so.6*
%{_datadir}/fplll/

%files devel
%{_includedir}/fplll.h
%{_includedir}/fplll/
%{_libdir}/libfplll.so
%{_libdir}/pkgconfig/fplll.pc

%files static
%{_libdir}/*.a

%files tools
%{_bindir}/*
%{_mandir}/man1/fplll.1*
%{_mandir}/man1/latsieve.1*
%{_mandir}/man1/latticegen.1*


%changelog
