Summary:   Library to program and control the FTDI USB serial controllers
Name:      libftdi1
Version:   1.5
Release:   alt2
License:   LGPL for libftdi and GPLv2+linking exception for the C++ wrapper
Group:     System/Libraries
URL:       http://www.intra2net.com/en/developer/libftdi
Packager:  Evgeny Sinelnikov <sin@altlinux.ru>

Source:    %name-%version.tar
BuildRequires: libusb-devel, pkg-config, doxygen
BuildRequires: gcc-c++ boost-devel
BuildRequires: rpm-macros-cmake
BuildRequires: cmake swig
BuildRequires: python3-devel rpm-build-python3
BuildRequires: libconfuse-devel


%define    namepp libftdipp1
%define    pyname python3-module-ftdi1

%define    soname libftdi1
%define    sonamepp libftdipp1

Patch:     %name-%version-alt.patch

%package   -n %namepp
Summary:   C++ interface for libftdi library
Group:     System/Libraries

%package   devel
Summary:   Header files and libraries for libftdi
Group:     Development/C
Requires:  %name = %version, libusb-devel

%package   -n ftdi-eeprom
Summary:   Tool for reading/erasing/flashing FTDI USB chip eeproms
Group:     Development/C

%package   -n %namepp-devel
Summary:   Header files and libraries for libftdipp
Group:     Development/C
Requires:  %name-devel = %version
Requires:  boost-devel

%package   devel-static
Summary:   Static libraries for libftdi
Group:     Development/C
Requires:  %name-devel = %version
Conflicts: libftdi-devel

%package   -n %namepp-devel-static
Summary:   Static libraries for libftdipp
Group:     Development/C
Requires:  %namepp-devel = %version

%package   -n %pyname
Summary:   Python bindings for libftdi
Group:     Development/Python
Requires:  %name = %version
AutoReqProv: yes,nopython

%package   docs
Summary:   Documentation files for libftdi
Group:     Development/C
BuildArch: noarch

%description 
Userspace library to program and control the FTDI
USB controllers, using libusb, including the popular
bitbang mode. This library talks to next FTDI chips:
FT232BM/245BM, FT2232C/D and FT232/245R.

%description -n %namepp
Full C++ wrapper for libftdi library

%description devel
Header files for userspace libftdi library

%description -n ftdi-eeprom
ftdi-eeprom is a small tool for creating and uploading the configuration
eeprom for the FTDI chip. This eeprom contains information such as vendor
and product ID, manufacturer and product strings, revision, etc.

%description -n %namepp-devel
Header files for full libftdi library C++ wrapper

%description devel-static
Static libraries for userspace libftdi library

%description -n %namepp-devel-static
Static libraries for full libftdi library C++ wrapper

%description -n %pyname
Python bindings for libftdi library

%description docs
Documentation files for userspace libftdi library

%prep
%setup
%patch -p1

%build
%cmake_insource \
    -D DOCUMENTATION=1 \
    -D PYTHON_BINDINGS=1 \
    -D FTDIPP=1 \
    -D FTDI_EEPROM=1 \
    -D EXAMPLES=1 \
    -D BUILD_TESTS=1
%make_build VERBOSE=1

%install
%makeinstall_std

# Install man pages
mkdir -p %buildroot%_mandir
cp -a doc/man/* %buildroot%_mandir/
mv %buildroot%_man3dir/size_and_time.3 %buildroot%_man3dir/ftdi_size_and_time.3
if test -f %buildroot%_man3dir/Libftdi.3; then
    mv %buildroot%_man3dir/Libftdi.3 %buildroot%_man3dir/libftdi.3
fi

%files
%_libdir/%soname.so.*

%files -n %namepp
%_libdir/%sonamepp.so.*

%files devel
%_bindir/%soname-config
%_libdir/%soname.so
%_libdir/pkgconfig/%soname.pc
%_includedir/%name/*.h
%_libdir/cmake/%name/*.cmake

%files -n ftdi-eeprom
%_bindir/ftdi_eeprom
%_docdir/%name/example.conf
%_man3dir/ftdi_eeprom*

%files -n %namepp-devel
%_libdir/%sonamepp.so
%_libdir/pkgconfig/%sonamepp.pc
%_includedir/%name/*.hpp

%files devel-static
%_libdir/%soname.a

%files -n %namepp-devel-static
%_libdir/%sonamepp.a

%files -n %pyname
%python3_sitelibdir/*.py*
%python3_sitelibdir/*.so
%python3_sitelibdir/*/ftdi1.*
%_datadir/libftdi/examples/*.py

%files docs
%doc doc/html
%_man3dir/*
%exclude %_man3dir/ftdi_eeprom*

%changelog
