Name: libggi
Version: 2.2.2
Release: alt3.1
Packager: Fr. Br. George <george@altlinux.ru>
%define gii_ver 1.0.2

BuildPreReq: libgii >= %gii_ver

Summary:  A fast, simple, small and flexible user-space graphics library (General Graphics Interface)

License:	GPL
Group: System/Libraries
URL: http://www.ggi-project.org/
Source:		http://www.ggi-project.org/ftp/ggi/v2.2/%name-%version.src.tar.bz2

Patch0: libggi-2.0.1-no-lcd823-ppc.patch
Patch1:	libggi-2.1.0-gcc4.patch
Patch2:	libggi-2.1.0-libtool.patch
Patch3:	libggi-2.0.3-xpath.patch
Patch4:	libggi-2.1.0-lib64.patch
Patch5:	libggi-2.1.1-glibc2.4-fix.patch

# Automatically added by buildreq on Fri Aug 20 2010
BuildRequires: aalib-devel imake libICE-devel libXext-devel libXt-devel libXxf86dga-devel libXxf86vm-devel libgii-devel libncurses-devel xorg-cf-files

%description
LibGGI is a fast, simple, small and flexible user-space graphics
library developed by the GGI Project <http://www.ggi-project.org/>.
It attempts to abstract the many different graphics output systems
existing under Unix (and in the future, other platforms). The support
for all of these different types of displays and hardware are provided
by dynamically-loaded mini-libraries.

LibGGI can transparently (to the LibGGI-using application) display
graphics on an X window, fbcon (Linux framebuffer driver), or the 
glide library, through their respective graphics drivers, or targets. 
There are also some other targets which display through another 
target, such as multi to display simultaneously on multiple displays 
at once, and tile to tile your display to different monitors.

LibGGI supports acceleration of graphics primitives where possible.

LibGGI is a very generic piece of software, that will run on about
every platform that has remotely heard of POSIX (ports to other systems
such as Win32 are underway) and on many display subsystems.

%package devel
Summary: development part of %name
Group: Development/C
Requires: %name = %version-%release
Requires: libgii-devel >= %gii_ver

%description devel
development files for %name

%package devel-static
Summary: development part of %name, static build
Group: Development/C
Requires: %name = %version-%release
Requires: libgii-devel >= %gii_ver

%description devel-static
development files for %name, static build

%package -n ggi-utils
Group: Graphics
Summary: some usefull utils from %name
Provides: %name-utils = %version
Obsoletes: %name-utils

%description -n ggi-utils
some usefull utils from %name

%prep
%setup -q
#add_optflags -I/usr/include/directfb-internal
%patch0 -p1 -b .ppc
#%patch1 -p1 -b .gcc4
#%patch2 -p1 -b .libtool
%patch3 -p1 -b .xpath
#%patch4 -p1 -b .lib64
#%patch5 -p1 -b .glibc2.4
# regenerate configure script
#./autogen.sh
#cat m4/[^l]*.m4 > acinclude.m4
#sed -i 's@PROG_RANLIB@PROG_LIBTOOL@
#/^LT_/d' configure.in

%build
#autoreconf -fisv
%configure
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall

%files
%doc FAQ NEWS README doc/env.txt doc/targets.txt
%config(noreplace) %_sysconfdir/ggi/*.conf
%config(noreplace) %_sysconfdir/ggi/targets/*.conf
%_libdir/*.so.*
%_libdir/ggi/default/*.so
%_libdir/ggi/display/*.so
%_libdir/ggi/helper/*.so
%_libdir/ggi/default/fbdev/*.so
%_mandir/man?/*

%files devel
%_includedir/*
%_libdir/*.so

%files devel-static
%_libdir/*.a
#_libdir/ggi/*/*.a
#_libdir/ggi/*/*/*.a

%files -n ggi-utils
%_bindir/*

%changelog
