%def_disable snapshot

%define rname glibmm
%define major 2.66
%define ver_base 2.66
%define api_ver 2.4

%def_enable docs
# see %%setup section below
%def_enable check

Name: libglibmm
Version: %major.2
Release: alt1

Summary: C++ wrapper for GLib
License: LGPL-2.1 and GPL-2.0
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/glibmm/%major/%rname-%version.tar.xz
%endif

%define glib_ver 2.61.2
%define sigc_ver 2.9.1

%add_perl_lib_path %_libdir/glibmm-%api_ver/proc/pm

BuildRequires(pre): meson
BuildRequires: mm-common gcc-c++
BuildRequires: libgio-devel >= %glib_ver libsigc++2-devel >= %sigc_ver
BuildRequires: perl-XML-Parser
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz fonts-ttf-open-sans xsltproc}

%description
A C++ interface for glib library.

This package contains the library needed to run programs dynamically
linked with glibmm.

%package devel
Summary: Headers and development files of glibmm
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
A C++ interface for glib library.

This package contains the headers and development files that are needed,
when trying to develop or compile applications which need glibmm.

%package doc
Summary: glibmm documentation
Group: Development/Documentation
BuildArch: noarch

%description doc
Gtkmm provides a C++ interface to the GTK+ GUI library.
glibmm originally belongs to gtkmm, but is now separated,
for use with non-GUI software written in C++.

This package contains all API documentation for glibmm.


%prep
%setup -n %rname-%version
# online tests restricted in hasher
sed -i  '/giomm_tls_client/d' tests/meson.build

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/glibmm-%api_ver/
%_includedir/giomm-%api_ver/
%_libdir/*.so
%_libdir/glibmm-%api_ver/
%_libdir/giomm-%api_ver/
%_pkgconfigdir/*-%api_ver.pc

%if_enabled docs
%files doc
%_docdir/%rname-%api_ver/
%_datadir/devhelp/books/%rname-%api_ver
%endif

%changelog
