%define ver_major 0.8
%define abiversion 0.8
%define _name goffice

Name: libgnomeoffice
Version: 0.8.17
Release: alt4

Summary: Library for writing gnome office programs
Group: Graphical desktop/GNOME
License: GPL
Url: http://projects.gnome.org/gnumeric/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
# not included in the tarball
Source1: go-conf-gsettings.c
Patch: libgnomeoffice-0.8.17-alt4-build.patch

Obsoletes: libgnomeoffice%abiversion
Provides: libgnomeoffice%abiversion = %version-%release

BuildRequires: flex libXext-devel libgsf-devel libgio-devel libxml2-devel
BuildRequires: libgtk+2-devel libpcre-devel intltool gtk-doc

%description
GOffice is a library that eases the task of writing gnome office
programs.

%package devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: %name = %version-%release
Obsoletes: libgnomeoffice%abiversion-devel
Provides: libgnomeoffice%abiversion-devel = %version-%release

%description devel
This package contains the header files and libraries needed to write and
compile programs that use %name.

%package devel-doc
Summary: Development documentation for Goffice
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package contains development documentation for Goffice library.

%define _libexecdir %_libdir/%name

%prep
%setup -n %_name-%version
%patch -p1

cp %SOURCE1 %_name/app/

%build
%autoreconf
%configure \
	--with-config-backend=gsettings

%make_build

%install
%makeinstall

%find_lang --output=%_name.lang %_name-%version

%files -f %_name.lang
%_libdir/*.so.*
%_libdir/goffice/
%_datadir/goffice/
%_datadir/pixmaps/goffice/*
%doc AUTHORS NEWS README

%exclude %_libdir/%_name/%version/plugins/*/*.la

%files devel
%_includedir/libgoffice-%abiversion/
%_libdir/*.so
%_libdir/pkgconfig/*

%files devel-doc
%_datadir/gtk-doc/html/%_name-%abiversion/

%changelog
