%define _name gssdp
%define ver_major 1.3
%define api_ver 1.2

%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_disable sniffer
%def_enable check

Name: lib%_name%api_ver
Version: %ver_major.0
Release: alt1

Summary: Resource discovery and announcement over SSDP
Group: System/Libraries
License: LGPLv2+
Url: http://www.gupnp.org/

Vcs: https://gitlab.gnome.org/GNOME/gssdp.git
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires(pre): meson >= 0.54.0 rpm-build-gir
BuildRequires: libsoup-devel >= 2.26.1 libgio-devel >= 2.54
BuildRequires: vala-tools rpm-build-vala libvala-devel
%{?_enable_gtk_doc:BuildRequires: gtk-doc gi-docgen}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libsoup-gir-devel}
%{?_enable_sniffer:BuildRequires: libgtk+3-devel >= 3.12}

%description
GSSDP implements resource discovery and announcement over SSDP and is part
of gUPnP.

%package devel
Summary: Development files for gSSDP library
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides files for development with gSSDP.

%package devel-doc
Summary: Development documentation for gSSDP
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gSSDP implements resource discovery and announcement over SSDP and is part
of gUPnP.

This package provides development documentation for gSSDP.

%package gir
Summary: GObject introspection data for the  library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the  library

%package gir-devel
Summary: GObject introspection devel data for the  library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GSSDP library

%package -n %_name%ver_major-tools
Summary: Graphical SSDP sniffer
Group: Networking/Other
Requires: %name = %version-%release

%description -n %_name%ver_major-tools
A Device Sniffer tool based on GSSDP framework.

%prep
%setup -n %_name-%version

%build
%meson \
    %{?_enable_gtk_doc:-Dgtk_doc=true} \
    %{?_disable_introspection:-Dintrospection=false} \
    %{?_disable_sniffer:-Dsniffer=false}
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_libdir/lib%_name-%api_ver.so.*
%doc AUTHORS README* NEWS

%files devel
%_includedir/%_name-%api_ver/
%_libdir/lib%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.deps
%_vapidir/%_name-%api_ver.vapi

%if_enabled gtk_doc
%files devel-doc
#%_datadir/gtk-doc/html/%_name
%_datadir/doc/%_name-%api_ver
%endif

%if_enabled introspection
%files gir
%_typelibdir/GSSDP-%api_ver.typelib

%files gir-devel
%_girdir/GSSDP-%api_ver.gir
%endif

%if_enabled sniffer
%files -n %_name%ver_major-tools
%_bindir/%_name-device-sniffer
%endif


%changelog
